% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/beta_conv_graph.R
\name{beta_conv_graph}
\alias{beta_conv_graph}
\title{Graphical representation based on beta convergence}
\usage{
beta_conv_graph(betaRes, indiName = NA, time_0 = NA, time_t = NA)
}
\arguments{
\item{betaRes}{the output obtained from beta_conv function.}

\item{indiName}{name of the  considered indicator as a string.}

\item{time_0}{starting time.}

\item{time_t}{ending time.}
}
\value{
a ggplot object to be displaied of saved using ggsave.
}
\description{
A ggplot of transformed data and a straight line for the results obtained for beta-convergence
}
\examples{


# Example 1
# Beta convergence for the emp_20_64_MS Eurofound dataset in the period 2002-2006:
data(emp_20_64_MS)
empBC <- beta_conv(emp_20_64_MS, time_0 = 2002, time_t = 2006, timeName = "time")

# Graphical plot based on the results for beta-convergence
empBCgraph <- beta_conv_graph(empBC,2002,2006,indiName = 'Employment rate')
empBCgraph

# Example 2
# Beta convergence for the emp_20_64_MS Eurofound dataset in the period 2008-2016:
empBC1 <- beta_conv(emp_20_64_MS, time_0 = 2008, time_t = 2016, timeName = "time")

# Graphical plot based on the results for beta-convergence
empBCgraph1 <- beta_conv_graph(empBC1,2008,2016,indiName = 'Employment rate')
empBCgraph1


}
\references{
{ \url{https://local.disia.unifi.it/stefanini/RESEARCH/coneu/tutorial-conv.html}}
}
