% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the_1x2_table_tests.R
\name{the_1x2_table_tests}
\alias{the_1x2_table_tests}
\title{The 1x2 Table tests}
\usage{
the_1x2_table_tests(X, n, pi0)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{pi0}{a given probability}
}
\value{
NULL. This function should be called for its printed output
}
\description{
The 1x2 Table tests
}
\examples{
# Example: The number of 1st order male births (Singh et al. 2010)
the_1x2_table_tests(singh_2010["1st", "X"], singh_2010["1st", "n"], pi0 = 0.513)
# Example: The number of 2nd order male births (Singh et al. 2010)
the_1x2_table_tests(singh_2010["2nd", "X"], singh_2010["2nd", "n"], pi0 = 0.513)
# Example: The number of 3rd order male births (Singh et al. 2010)
the_1x2_table_tests(singh_2010["3rd", "X"], singh_2010["3rd", "n"], pi0 = 0.513)
# Example: The number of 4th order male births (Singh et al. 2010)
the_1x2_table_tests(singh_2010["4th", "X"], singh_2010["4th", "n"], pi0 = 0.513)
# Example: Ligarden et al. (2010)
the_1x2_table_tests(ligarden_2010["X"], ligarden_2010["n"], pi0 = 0.5)
}
