% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pearson_LR_tests_rxc.R
\name{Pearson_LR_tests_rxc}
\alias{Pearson_LR_tests_rxc}
\title{The Pearson chi-squared and likelihood ratio tests for association in rxc tables}
\usage{
Pearson_LR_tests_rxc(n)
}
\arguments{
\item{n}{the observed counts (an rxc matrix)}
}
\value{
An object of the \link{contingencytables_result} class,
basically a subclass of \code{\link[base:list]{base::list()}}. Use the \code{\link[utils:str]{utils::str()}} function
to see the specific elements returned.
}
\description{
The Pearson chi-squared and likelihood ratio tests for association in rxc tables

Described in Chapter 7 "The rxc Table"
}
\examples{
# Examples from Chapter 5 (ordered rx2 tables)

## Alcohol consumption and malformations (Mills and Graubard, 1987):
Pearson_LR_tests_rxc(mills_graubard_1987)

## Elevated troponin T levels in stroke patients (Indredavik et al., 2008):
Pearson_LR_tests_rxc(indredavik_2008)

# Examples from Chapter 6 (ordered 2xc tables)
## The Adolescent Placement Study (Fontanella et al., 2008):
Pearson_LR_tests_rxc(fontanella_2008)

## Postoperative nausea (Lydersen et al., 2012a):
Pearson_LR_tests_rxc(lydersen_2012a)

# Examples from Chapter 7 (unordered rxc tables)

## Treatment for ear infection (van Balen et al., 2003):
Pearson_LR_tests_rxc(table_7.3)

## Psychiatric diagnoses vs PA (Mangerud et al., 2004):
Pearson_LR_tests_rxc(table_7.4)

## Psychiatric diag. vs BMI (Mangerud et al., 2004):
Pearson_LR_tests_rxc(table_7.5)
}
