% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/the_1x2_table_CIs.R
\name{the_1x2_table_CIs}
\alias{the_1x2_table_CIs}
\title{The 1x2 Table CIs}
\usage{
the_1x2_table_CIs(X, n, alpha = 0.05)
}
\arguments{
\item{X}{the number of successes}

\item{n}{the total number of observations}

\item{alpha}{the nominal level, e.g. 0.05 for 95\% CIs}
}
\value{
NULL. This function should be called for its printed output
}
\description{
The 1x2 Table CIs
}
\examples{
# The number of 1st order male births (Singh et al. 2010)
the_1x2_table_CIs(X=250, n=533)
# The number of 2nd order male births (Singh et al. 2010)
the_1x2_table_CIs(X=204, n=412)
# The number of 3rd order male births (Singh et al. 2010)
the_1x2_table_CIs(X=103, n=167)
# The number of 4th order male births (Singh et al. 2010)
the_1x2_table_CIs(X=33, n=45)
# Ligarden et al. (2010)
the_1x2_table_CIs(X=13, n=16)

}
