% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Score_test_for_effect_in_the_probit_model_2xc.R
\name{Score_test_for_effect_in_the_probit_model_2xc}
\alias{Score_test_for_effect_in_the_probit_model_2xc}
\title{Score test for effect in the cumulative probit model}
\usage{
Score_test_for_effect_in_the_probit_model_2xc(
  n,
  alphahat0,
  printresults = TRUE
)
}
\arguments{
\item{n}{the observed counts (a 2xc matrix)}

\item{alphahat0}{a column vector with c-1 estimated coefficients
(\code{alpha_j}) under the null hypothesis (\code{beta = 0})}

\item{printresults}{display results (F = no, T = yes)}
}
\value{
A list containing the probability, the statistic and the degrees of freedom
}
\description{
The score test for effect in the cumulative probit model
described in Chapter 6 "The Ordered 2xc Table"
}
\note{
Must give the alphahats under the null hypothesis as input,
because Matlab does not calculate an intercept-only probit model (and this
may apply to R code as well). alphahat0 can be calculated in, for instance,
Stata.
}
\examples{
# The Adolescent Placement Study (Fontanella et al., 2008)
n <- rbind(c(8, 28, 72, 126), c(46, 73, 69, 86))
alphahat0 <- c(-1.246452, -0.5097363, 0.2087471)
Score_test_for_effect_in_the_probit_model_2xc(n, alphahat0)

# Postoperative nausea (Lydersen et al., 2012a)
n <- rbind(c(14, 10, 3, 2), c(11, 7, 8, 4))
alphahat0 <- c(-0.1923633, 0.5588396, 1.271953)
Score_test_for_effect_in_the_probit_model_2xc(n, alphahat0)

}
