% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Pearson_residuals_rxc.R
\name{Pearson_residuals_rxc}
\alias{Pearson_residuals_rxc}
\title{The Pearson residuals and the standardized Pearson residuals}
\usage{
Pearson_residuals_rxc(n, printresults = TRUE)
}
\arguments{
\item{n}{the observed counts (an rxc matrix)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A list containing matrices of the Pearson residuals and the standardized Pearson residuals
}
\description{
The Pearson residuals and the standardized Pearson residuals

Described in Chapter 7 "The rxc Table"
}
\examples{
# Treatment for ear infection (van Balen et al., 2003)
n <- matrix(c(40, 25, 54, 7, 63, 10), ncol = 2, byrow = TRUE)
Pearson_residuals_rxc(n)

# Psychiatric diagnoses vs PA (Mangerud et al., 2004)
n <- matrix(
  c(62, 21, 97, 48, 10, 12, 30, 7, 132, 78, 34, 17),
  ncol = 2, byrow = TRUE
)
Pearson_residuals_rxc(n)

# Psychiatric diag. vs BMI (Mangerud et al., 2004)
n <- rbind(
  c(3, 55, 23), c(8, 102, 36), c(6, 14, 1),
  c(5, 21, 12), c(19, 130, 64), c(7, 26, 18)
)
Pearson_residuals_rxc(n)
}
