% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exact_cond_midP_linear_rank_tests_2xc.R
\name{Exact_cond_midP_linear_rank_tests_2xc}
\alias{Exact_cond_midP_linear_rank_tests_2xc}
\title{Exact conditional and mid-P linear rank tests}
\usage{
Exact_cond_midP_linear_rank_tests_2xc(n, b = 0, printresults = TRUE)
}
\arguments{
\item{n}{the observed table (a 2xc matrix)}

\item{b}{scores assigned to the columns (if b=0, midranks will be used as scores)}

\item{printresults}{display results (FALSE = no, TRUE = yes)}
}
\value{
A data frame containing the two-sided, twice-the-smallest tail P-value and the mid-P value
}
\description{
Exact conditional and mid-P linear rank tests

Described in Chapter 6 "The Ordered 2xc Table"
}
\examples{
\dontrun{
# The Adolescent Placement Study (Fontanella et al., 2008)
n <- rbind(c(8, 28, 72, 126),c(46, 73, 69, 86))
Exact_cond_midP_linear_rank_tests_2xc(n)
}

# Postoperative nausea (Lydersen et al., 2012a)
n <- rbind(c(14, 10, 3, 2), c(11, 7, 8, 4))
Exact_cond_midP_linear_rank_tests_2xc(n)

}
