% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3-formula.R
\name{opts_formula}
\alias{opts_formula}
\title{Constructive options for formulas}
\usage{
opts_formula(
  constructor = c("~", "formula", "as.formula", "new_formula"),
  ...,
  environment = TRUE
)
}
\arguments{
\item{constructor}{String. Name of the function used to construct the environment, see Details section.}

\item{...}{Should not be used. Forces passing arguments by name.}

\item{environment}{Boolean. Whether to attempt to construct the environment, if
it makes a difference to construct it.

Depending on \code{constructor}, we construct the formula as follows:
\itemize{
\item \code{"~"} (default): We construct the formula in the most common way using the \code{~}
operator.
\item \code{"formula"} : deparse the formula as a string and use \code{base::formula()} on top of it.
\item \code{"as.formula"} : Same as above, but using \code{base::as.formula()}.
\item \code{"new_formula"} : extract both sides of the formula as separate language objects
and feed them to \code{rlang::new_formula()}, along with the reconstructed environment
if relevant.
}}
}
\value{
An object of class <constructive_options/constructive_options_environment>
}
\description{
These options will be used on formulas, defined as calls to \code{~}, regardless
of their \code{"class"} attribute.
}
