% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constants.R
\docType{data}
\name{codata}
\alias{codata}
\alias{codata.cor}
\title{CODATA Recommended Values of the Fundamental Physical Constants: 2018}
\format{
An object of class \code{data.frame} with the following information
for each physical constant:
ASCII \code{symbol}, \code{quantity} description, \code{type},
\code{value}, \code{uncertainty}, \code{unit}.

A \code{matrix} of correlations between physical constants.
}
\source{
Eite Tiesinga, Peter J. Mohr, David B. Newell, and Barry N. Taylor (2020).
The 2018 CODATA Recommended Values of the Fundamental Physical Constants
(Web Version 8.1). Database developed by J. Baker, M. Douma, and S. Kotochigova.
Available at http://physics.nist.gov/constants,
National Institute of Standards and Technology, Gaithersburg, MD 20899.
}
\usage{
codata

codata.cor
}
\description{
The Committee on Data for Science and Technology (CODATA) is an interdisciplinary
committee of the International Council for Science. The Task Group on Fundamental
Constants periodically provides the internationally accepted set of values of
the fundamental physical constants. This dataset contains the "2018 CODATA"
version, published on May 2019.
}
\seealso{
\code{\link{syms}}, \code{\link{lookup}}.
}
\keyword{datasets}
