% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_box.R
\name{add_box}
\alias{add_box}
\title{Add nodes}
\usage{
add_box(
  prev_box = NULL,
  txt,
  just = "center",
  dist = 0.02,
  y = unit(0.9, "npc"),
  text_width = NULL,
  ...
)
}
\arguments{
\item{prev_box}{Previous node object, the created new node will be vertically
aligned with this node. Left this as `NULL` if this is the first node. The first
node will be aligned in the top center.}

\item{txt}{Text in the node. If the `prev_box` is a horizontally aligned multiple
nodes, a vector of with the same length must be provided.}

\item{just}{The justification for the text: left, center or right.}

\item{dist}{Distance between previous node, including the distance between the
side node.}

\item{y}{A number or unit object specifying y-location of the starting point of
the diagram, default is 0.9npc. Will be ignored if \code{prev_box} is not null.}

\item{text_width}{a positive integer giving the target column for wrapping
lines in the output. String will not be wrapped if not defined (default).
The \code{\link[stringi]{stri_wrap}} function will be used if \code{stringi}
package installed, otherwise \code{\link[base]{strwrap}} will be used.}

\item{...}{Other parameters pass to \link{textbox},}
}
\value{
A \code{consort} object.
}
\description{
Create/add vertically aligned labeled nodes or side nodes.
}
\examples{
txt1 <- "Population (n=300)"
txt1_side <- "Excluded (n=15): \n
              \u2022 MRI not collected (n=3)\n
              \u2022 Tissues not collected (n=4)\n
              \u2022 Other (n=8)"

g <- add_box(txt = txt1)

g <- add_side_box(g, txt = txt1_side)

g <- add_box(g, txt = "Randomized (n=200)")

g <- add_split(g, txt = c("Arm A (n=100)", "Arm B (n=100"))
g <- add_side_box(g,
  txt = c(
    "Excluded (n=15):\n
                  \u2022 MRI not collected (n=3)\n
                   \u2022 Tissues not collected (n=4)\n
                   \u2022 Other (n=8)",
    "Excluded (n=15):\n
                    \u2022 MRI not collected (n=3)\n
                    \u2022 Tissues not collected (n=4)"
  )
)

g <- add_box(g,
  txt = c(
    "Final analysis (n=100)",
    "Final analysis (n=100"
  )
)
}
\seealso{
\code{\link{add_side_box}},\code{\link{add_split}}
}
