% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/communities.R
\name{multitrap.community}
\alias{multitrap.community}
\title{Constructs a two-step clustering, first running multilevel.communities, and then walktrap.communities within each
These are combined into an overall hierarchy}
\usage{
multitrap.community(
  graph,
  n.cores = parallel::detectCores(logical = FALSE),
  hclust.link = "single",
  min.community.size = 10,
  verbose = FALSE,
  level = NULL,
  ...
)
}
\arguments{
\item{graph}{graph}

\item{n.cores}{numeric Number of cores to use (default=parallel::detectCores(logical=FALSE))}

\item{hclust.link}{character Link function to use when clustering multilevel communities (based on collapsed graph connectivity) (default='single')}

\item{min.community.size}{numeric Minimal community size parameter for the walktrap communities .. communities smaller than that will be merged (default=10)}

\item{verbose}{boolean Whether to output progress messages (default=FALSE)}

\item{level}{numeric What level of multitrap clustering to use in the starting step. By default, uses the top level. An integer can be specified for a lower level (i.e. 1) (default=NULL)}

\item{...}{passed to walktrap}
}
\value{
a fakeCommunities object that has methods membership() and as.dendrogram() to mimic regular igraph returns
}
\description{
Constructs a two-step clustering, first running multilevel.communities, and then walktrap.communities within each
These are combined into an overall hierarchy
}
\keyword{internal}
