% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/dbi_methods.R, R/fs_methods.R
\name{remove_cnt}
\alias{remove_cnt}
\alias{remove_cnt.ConnectorDBI}
\alias{remove_cnt.ConnectorFS}
\title{Remove content from the connector}
\usage{
remove_cnt(connector_object, name, ...)

\method{remove_cnt}{ConnectorDBI}(connector_object, name, ...)

\method{remove_cnt}{ConnectorFS}(connector_object, name, ...)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{name}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to remove content from different connectors:

\itemize{
\item \link{ConnectorDBI}: Uses \code{\link[DBI:dbRemoveTable]{DBI::dbRemoveTable()}} to remove the table from a DBI connection.
}

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[fs:delete]{fs::file_delete()}} to delete the file.
}
}
\examples{
# Remove table in a DBI database
cnt <- connector_dbi(RSQLite::SQLite())

cnt |>
  write_cnt(iris, "iris") |>
  list_content_cnt()

cnt |>
  remove_cnt("iris") |>
  list_content_cnt()

# Remove a file from the file storage

folder <- withr::local_tempdir()
cnt <- connector_fs(folder)

cnt |>
  write_cnt("this is an example", "example.txt")
cnt |>
  list_content_cnt(pattern = "example.txt")

cnt |>
  read_cnt("example.txt")

cnt |>
  remove_cnt("example.txt")

cnt |>
  list_content_cnt(pattern = "example.txt")

}
