% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cnt_generics.R, R/fs_methods.R
\name{download_cnt}
\alias{download_cnt}
\alias{download_cnt.ConnectorFS}
\title{Download content from the connector}
\usage{
download_cnt(connector_object, name, file = basename(name), ...)

\method{download_cnt}{ConnectorFS}(connector_object, name, file = basename(name), ...)
}
\arguments{
\item{connector_object}{\link{Connector} The connector object to use.}

\item{name}{\link{character} Name of the content to read, write, or remove. Typically the table name.}

\item{file}{\link{character} Path to the file to download to or upload from}

\item{...}{Additional arguments passed to the method for the individual connector.}
}
\value{
\link{invisible} connector_object.
}
\description{
Generic implementing of how to download files from a connector:

\itemize{
\item \link{ConnectorFS}: Uses \code{\link[fs:copy]{fs::file_copy()}} to copy a file from the file storage
to the desired \code{file}.
}
}
\examples{
# Download file from a file storage

folder <- withr::local_tempdir()
cnt <- connector_fs(folder)

cnt |>
  write_cnt("this is an example", "example.txt")

list.files(pattern = "example.txt")

cnt |>
  download_cnt("example.txt")

list.files(pattern = "example.txt")
readLines("example.txt")

cnt |>
  remove_cnt("example.txt")

}
