% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_config.R
\name{add_metadata}
\alias{add_metadata}
\title{Add metadata to a YAML configuration file}
\usage{
add_metadata(config_path, key, value)
}
\arguments{
\item{config_path}{The file path to the YAML configuration file}

\item{key}{The key for the new metadata entry}

\item{value}{The value for the new metadata entry}
}
\value{
The updated configuration after adding the new metadata
}
\description{
This function adds metadata to a YAML configuration file by modifying the provided
key-value pair in the metadata section of the file.
}
\examples{
# Read the YAML file
test_config <- system.file("config", "default_config.yml", package = "connector")
file.copy(test_config, "test_config.yaml")

# Add metadata
config <- add_metadata("test_config.yaml", "new_metadata", "new_value")

unlink("test_config.yaml")

}
