% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_f_ncp.R
\name{ci_f_ncp}
\alias{ci_f_ncp}
\title{Confidence Interval for the Non-Centrality Parameter of the F Distribution}
\usage{
ci_f_ncp(x, df1 = NULL, df2 = NULL, probs = c(0.025, 0.975))
}
\arguments{
\item{x}{The result of \code{lm} or the F test statistic.}

\item{df1}{The numerator degree of freedom, e.g. the number of parameters (including the intercept) of a linear regression. Only used if \code{x} is a test statistic.}

\item{df2}{The denominator degree of freedom, e.g. n - df1 - 1 in a linear regression. Only used if \code{x} is a test statistic.}

\item{probs}{Error probabilites. The default c(0.025, 0.975) gives a symmetric 95\% confidence interval.}
}
\value{
A list with class \code{cint} containing these components:
\itemize{
\item \code{parameter}: The parameter in question.
\item \code{interval}: The confidence interval for the parameter.
\item \code{estimate}: The estimate for the parameter.
\item \code{probs}: A vector of error probabilities.
\item \code{type}: The type of the interval.
\item \code{info}: An additional description text for the interval.
}
}
\description{
Based on the inversion principle, parametric confidence intervals for the non-centrality parameter Delta of the F distribution are calculated. Note that we do not provide bootstrap confidence intervals here to keep the input interface simple. A positive lower (1-alpha)*100\%-confidence limit for the ncp goes hand-in-hand with a significant F test at level alpha.
}
\details{
Note that, according to \code{?pf}, the results might be unreliable for very large F values.
}
\examples{
fit <- lm(Sepal.Length ~ ., data = iris)
ci_f_ncp(fit)
ci_f_ncp(fit, probs = c(0.05, 1))
ci_f_ncp(fit, probs = c(0, 0.95))
ci_f_ncp(x = 188.251, df1 = 5, df2 = 144)
}
\references{
Smithson, M. (2003). Confidence intervals. Series: Quantitative Applications in the Social Sciences. New York, NY: Sage Publications.
}
\seealso{
\code{\link{ci_rsquared}}.
}
