% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/merge.R
\name{eval.config.merge}
\alias{eval.config.merge}
\title{Merge config parameter sets by sections.}
\usage{
eval.config.merge(file = Sys.getenv("R_CONFIGFILE_ACTIVE", "config.cfg"),
  sections = NULL, ...)
}
\arguments{
\item{file}{File name of configuration file to read from. Defaults to the value of
the 'R_CONFIGFILE_ACTIVE' environment variable ('config.cfg' if the
variable does not exist and JSON/INI/YAML/TOML format only)}

\item{sections}{Need be merged parameter sets, eg. sections=c('default', 'version'), will 
default to all of config sections}

\item{...}{Arguments for \code{\link{get.config.type}}, 
\code{\link{eval.config.sections}}, \code{\link{eval.config}}}
}
\value{
A list or logical FALSE indicating that is not standard JSON/INI/YAML/TOML format file
}
\description{
Merge config parameter sets by sections.
}
\examples{
config.json <- system.file('extdata', 'config.json', package='configr')
config.ini <- system.file('extdata', 'config.ini', package='configr')
config.yaml <- system.file('extdata', 'config.yaml', package='configr')
config.toml <- system.file('extdata', 'config.toml', package='configr')
eval.config.merge(config.json)
eval.config.merge(config.ini)
eval.config.merge(config.yaml)
eval.config.merge(config.toml)
}
\seealso{
\code{\link{eval.config.sections}} which only get all of the mainly parameter sets name in config file, 
\code{\link{read.config}} which only read from a config as a list,
\code{\link{eval.config}} which only read one sections as config obj or a value from config file.
}
