% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create.R
\name{cs_prep_year}
\alias{cs_prep_year}
\title{Prepare Raw Data}
\usage{
cs_prep_year(path, verbose = FALSE)
}
\arguments{
\item{path}{File path where raw STLMPD data are}

\item{verbose}{If \code{TRUE}, returns a tibble with results; otherwise if \code{FALSE}, no
output is returned.}
}
\value{
A tibble containing old file names and new file names for reference is \code{verbose = TRUE}.
    Otherwise, no output is returned. This function will change all problematic filenames in the
    specified path.
}
\description{
Data downloaded from the St. Louis Metropolitan Police Department
   are downloaded with incorrect file paths - e.g. \code{January2008.CSV.html}.
   This function iterates over all files in a given path and replaces their
   file extensions. Thus \code{January2008.CSV.html} will be replaced by
   \code{january2008.csv}. There should be no more than 12 files in a given path,
   and all should correspond to the same year.
}
\examples{
# create temporary directory
tmpdir <- tempdir()
fs::dir_create(paste0(tmpdir,"/data/"))

# load sample files into temporary directory
cs_example(path = paste0(tmpdir,"/data/"))

# list files
list.files(paste0(tmpdir,"/data/"))

# prep sample files
cs_prep_year(path = paste0(tmpdir,"/data/"))

# list files again
list.files(paste0(tmpdir,"/data/"))

# delete data
fs::dir_delete(paste0(tmpdir,"/data/"))

# create temporary directory
fs::dir_create(paste0(tmpdir,"/data/"))

# load sample files into temporary directory
cs_example(path = paste0(tmpdir,"/data/"))

# prep sample files
cs_prep_year(path = paste0(tmpdir,"/data/"), verbose = TRUE)

# delete data again
fs::dir_delete(paste0(tmpdir,"/data/"))

}
