% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complmrob.R
\name{complmrob}
\alias{complmrob}
\title{MM-type estimators for linear regression on compositional data}
\usage{
complmrob(formula, data)
}
\arguments{
\item{formula}{The formula for the regression model}

\item{data}{The data.frame to use}
}
\value{
A list of type \code{complmrob} with fields
     \describe{
         \item{coefficients}{the estimated coefficients}
         \item{models}{the single regression models (one for each orthonormal basis)}
         \item{npred}{the number of predictor variables}
         \item{predictors}{the names of the predictor variables}
         \item{coefind}{the index of the relevant coefficient in the single regression models}
         \item{call}{how the function was called}
         \item{intercept}{if an intercept is included}
     }
}
\description{
Uses the \code{\link[robustbase]{lmrob}} method for robust linear regression models to fit
linear regression models to compositional data.
}
\details{
The variables on the right-hand-side of the formula are transformed with the isometric log-ratio
transformation (\code{\link{isomLR}}) and a robust linear regression model is fit to
those transformed variables. The orthonormal basis can be constructed in \code{p} different ways,
where \code{p} is the number of variables on the RHS of the formula.

To get an interpretable estimate of the regression coefficient for each part of the composition,
the data is transformed separately for each part. To estimate the coefficient for the *k*-th
part, the *k*-th part is used as the orthonormal basis in the transformation and a regression model
is fit to this data.
}
\examples{
crimes <- data.frame(lifeExp = state.x77[, "Life Exp"],
                     USArrests[ , c("Murder", "Assault", "Rape")])
mUSArr <- complmrob(lifeExp ~ ., data = crimes)
summary(mUSArr)

}
\references{
K. Hron, P. Filzmoser & K. Thompson (2012): Linear regression with compositional explanatory
     variables, Journal of Applied Statistics, DOI:10.1080/02664763.2011.644268
}
