% Generated by roxygen2 (4.0.1): do not edit by hand
\name{bootcoefs}
\alias{bootcoefs}
\alias{bootcoefs.complmrob}
\alias{bootcoefs.lmrob}
\title{Bootstrap the regression coefficients for a robust linear regression model}
\usage{
bootcoefs(object, R = 999, method = c("frb", "residuals", "cases"),
  ncpus = NULL, cl = NULL, ...)

\method{bootcoefs}{complmrob}(object, R = 999, method = c("frb",
  "residuals", "cases"), ncpus = NULL, cl = NULL, ...)

\method{bootcoefs}{lmrob}(object, R = 999, method = c("frb", "residuals",
  "cases"), ncpus = NULL, cl = NULL, ...)
}
\arguments{
\item{object}{the model to bootstrap the coefficients from}

\item{R}{the number of bootstrap replicates.}

\item{method}{one of \code{"frb"} for fast and robust bootstrap, \code{"residuals"} to resample
the residuals or \code{"cases"} to resample the cases.}

\item{ncpus}{the number of CPUs to utilize for bootstrapping.}

\item{cl}{a snow or parallel cluster to use for bootstrapping.}

\item{...}{currently ignored.}
}
\value{
A list of type \code{bootcoefs} for which \code{\link[=print.bootcoefs]{print}},
     \code{\link{summary}} and \code{\link[=plot.bootcoefs]{plot}} methods are available
}
\description{
This function provides an easy interface and useful output to bootstrapping the regression
coefficients of robust linear regression models
}
\details{
The default method is to use fast and robust bootstrap as described in the paper by M. Salibian-Barrera, et al.
(see references). The other options are to bootstrap the residuals or to bootstrap cases (observations),
but the sampling distribution of the estimates from these methods can be numerically instable and take
longer to compute.
}
\section{Methods (by class)}{
\itemize{
\item \code{complmrob}: For robust linear regression models with compositional data

\item \code{lmrob}: For standard robust linear regression models
}}
\examples{
data <- data.frame(lifeExp = state.x77[, "Life Exp"], USArrests[ , -3])
mUSArr <- complmrob(lifeExp ~ ., data = data)
bc <- bootcoefs(mUSArr, R = 200) # the number of bootstrap replicates should
                                 # normally be higher!
summary(bc)
plot(bc) # for the model diagnostic plots
}
\references{
M. Salibian-Barrera, S. Aelst, and G. Willems. Fast and robust bootstrap. Statistical Methods and Applications, 17(1):41-71, 2008.
}

