% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/devries.R
\name{devries}
\alias{devries}
\title{Calculate the linearity of a dominance hierarchy - De Vries' method}
\usage{
devries(m, Nperms = 10000, history = FALSE, plot = FALSE)
}
\arguments{
\item{m}{A matrix with individuals ordered identically in rows and columns.}

\item{Nperms}{Number of randomizations}

\item{history}{Whether to store results of randomization}

\item{plot}{Whether to plot results of randomization}
}
\value{
The modified Landau's h' value of \code{m}, the associated p-value
}
\description{
Calculate the linearity of a dominance hierarchy - De Vries' method
}
\section{References}{

Han de Vries (1995) An improved test of linearity in dominance hierarchies
containing unknown or tied relationships. Animal Behaviour 50 pp. 1375-1389.
}

\section{Further details}{

This code is an edited and faster version of code originally written by Dai Shizuka.
http://biosci.unl.edu/daizaburo-shizuka
Note that plot will only be shown if \strong{\code{history}=F}
}
\examples{
devries(bonobos)
devries(mouse,plot=TRUE)
devries(people,history=TRUE)
}

