% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hype_par_discretenum.R
\name{R6_par_discretenum}
\alias{R6_par_discretenum}
\title{R6 object for discrete numeric}
\description{
R6 object for discrete numeric

R6 object for discrete numeric
}
\details{
Parameter with uniform distribution for hyperparameter optimization
}
\examples{
p1 <- R6_par_discretenum$new('x1', 0:2)
class(p1)
print(p1)
}
\section{Super class}{
\code{comparer::par_hype} -> \code{par_discretenum}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{name}}{Name of the parameter, must match the input to `eval_func`.}

\item{\code{values}}{Values, discrete numeric}

\item{\code{ggtrans}}{Transformation for ggplot, see ggplot2::scale_x_continuous()}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-par_discretenum-fromraw}{\code{R6_par_discretenum$fromraw()}}
\item \href{#method-par_discretenum-toraw}{\code{R6_par_discretenum$toraw()}}
\item \href{#method-par_discretenum-generate}{\code{R6_par_discretenum$generate()}}
\item \href{#method-par_discretenum-getseq}{\code{R6_par_discretenum$getseq()}}
\item \href{#method-par_discretenum-isvalid}{\code{R6_par_discretenum$isvalid()}}
\item \href{#method-par_discretenum-convert_to_mopar}{\code{R6_par_discretenum$convert_to_mopar()}}
\item \href{#method-par_discretenum-new}{\code{R6_par_discretenum$new()}}
\item \href{#method-par_discretenum-print}{\code{R6_par_discretenum$print()}}
\item \href{#method-par_discretenum-clone}{\code{R6_par_discretenum$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_discretenum-fromraw"></a>}}
\if{latex}{\out{\hypertarget{method-par_discretenum-fromraw}{}}}
\subsection{Method \code{fromraw()}}{
Function to convert from raw scale to transformed scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_discretenum$fromraw(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Value of raw scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_discretenum-toraw"></a>}}
\if{latex}{\out{\hypertarget{method-par_discretenum-toraw}{}}}
\subsection{Method \code{toraw()}}{
Function to convert from transformed scale to raw scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_discretenum$toraw(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Value of transformed scale}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_discretenum-generate"></a>}}
\if{latex}{\out{\hypertarget{method-par_discretenum-generate}{}}}
\subsection{Method \code{generate()}}{
Generate values in the raw space based on quantiles.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_discretenum$generate(q)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{q}}{In [0,1].}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_discretenum-getseq"></a>}}
\if{latex}{\out{\hypertarget{method-par_discretenum-getseq}{}}}
\subsection{Method \code{getseq()}}{
Get a sequence, uniform on the transformed scale
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_discretenum$getseq(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of points. Ignored for discrete.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_discretenum-isvalid"></a>}}
\if{latex}{\out{\hypertarget{method-par_discretenum-isvalid}{}}}
\subsection{Method \code{isvalid()}}{
Check if input is valid for parameter
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_discretenum$isvalid(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{Parameter value}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_discretenum-convert_to_mopar"></a>}}
\if{latex}{\out{\hypertarget{method-par_discretenum-convert_to_mopar}{}}}
\subsection{Method \code{convert_to_mopar()}}{
Convert this to a parameter for the
mixopt R package.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_discretenum$convert_to_mopar(raw_scale = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{raw_scale}}{Should it be on the raw scale?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_discretenum-new"></a>}}
\if{latex}{\out{\hypertarget{method-par_discretenum-new}{}}}
\subsection{Method \code{new()}}{
Create a hyperparameter with uniform distribution
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_discretenum$new(name, values)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the parameter, must match the input to `eval_func`.}

\item{\code{values}}{Numeric values, must be in ascending order}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_discretenum-print"></a>}}
\if{latex}{\out{\hypertarget{method-par_discretenum-print}{}}}
\subsection{Method \code{print()}}{
Print details of the object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_discretenum$print(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{not used}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-par_discretenum-clone"></a>}}
\if{latex}{\out{\hypertarget{method-par_discretenum-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{R6_par_discretenum$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
