% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffexp.R
\name{ffexp}
\alias{ffexp}
\title{Full factorial experiment}
\description{
A class for easily creating and evaluating full factorial experiments.
}
\section{Usage}{

\preformatted{
e1 <- ffexp$new(eval_func=, )

e1$run_all()

e1$plot_run_times()

e1$save_self()

}
}

\section{Arguments}{

\code{eval_func} The function called to evaluate each design point.

\code{...} Factors and their levels to be evaluated at.

\code{save_output} Should the output be saved?

\code{parallel} If \code{TRUE}, function evaluations are done in parallel.

\code{parallel_cores} Number of cores to be used in parallel.
If \code{"detect"}, \code{parallel::detectCores()} is used to determine
number. \code{"detect-1"} may be used so that the computer isn't running
at full capacity, which can slow down other tasks.
}

\section{Methods}{

\code{$new()} Initialize an experiment. The preprocessing is done,
but no function evaluations are run.

\code{$run_all()} Run all factor combinations.

\code{$run_one()} Run a single factor combination.

\code{$add_result_of_one()} Used to add result of evaluation to data set,
don't manually call.

\code{$plot_run_times()} Plot the run times. Especially useful when
they have been run in parallel.

\code{$save_self()} Save ffexp R6 object.

\code{$recover_parallel_temp_save()} If you ran the experiment using
parallel with \code{parallel_temp_save=TRUE} and it crashes partway
through, call this to recover the runs that were completed.
Runs that were stopped mid-execution are not recoverable.
}

\examples{
# Two factors, both with two levels.
#   The evaluation function simply prints out the combination
cc <- ffexp$new(a=1:2,b=c("A","B"),
                eval_func=function(...) {c(...)})
# View the factor settings it will run (each row).
cc$rungrid
# Evaluate all four settings
cc$run_all()


cc <- ffexp$new(a=1:3,b=2, cd=data.frame(c=3:4,d=5:6),
                eval_func=function(...) {list(...)})
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{outrawdf}}{Raw data frame of output.}

\item{\code{outcleandf}}{Clean output in data frame.}

\item{\code{rungrid}}{matrix specifying which inputs will be run
for each experiment.}

\item{\code{nvars}}{Number of variables}

\item{\code{allvars}}{All variables}

\item{\code{varlist}}{Character vector of objects to pass to a parallel
cluster.}

\item{\code{arglist}}{List of values for each argument}

\item{\code{number_runs}}{Total number of runs}

\item{\code{completed_runs}}{Logical vector of whether each run has been
completed.}

\item{\code{eval_func}}{The function that is called for each experiment trial.}

\item{\code{outlist}}{A list of the output from each run.}

\item{\code{save_output}}{Logical of whether the output should be saved.}

\item{\code{parallel}}{Logical whether experiment runs should be run in
parallel. Allows for massive speedup.}

\item{\code{parallel_cores}}{How many cores to use when running in parallel.
Can be an integer, or 'detect' will detect how many cores are
available, or 'detect-1' will do one less than that.}

\item{\code{parallel_cluster}}{The parallel cluster being used.}

\item{\code{folder_path}}{The path to the folder where output will be saved.}

\item{\code{verbose}}{How much should be printed when running. 0 is none,
2 is average.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{ffexp$new()}}
\item \href{#method-run_all}{\code{ffexp$run_all()}}
\item \href{#method-run_for_time}{\code{ffexp$run_for_time()}}
\item \href{#method-run_superbatch}{\code{ffexp$run_superbatch()}}
\item \href{#method-run_one}{\code{ffexp$run_one()}}
\item \href{#method-add_result_of_one}{\code{ffexp$add_result_of_one()}}
\item \href{#method-plot_run_times}{\code{ffexp$plot_run_times()}}
\item \href{#method-plot_pairs}{\code{ffexp$plot_pairs()}}
\item \href{#method-plot}{\code{ffexp$plot()}}
\item \href{#method-calculate_effects}{\code{ffexp$calculate_effects()}}
\item \href{#method-calculate_effects2}{\code{ffexp$calculate_effects2()}}
\item \href{#method-save_self}{\code{ffexp$save_self()}}
\item \href{#method-create_save_folder_if_nonexistent}{\code{ffexp$create_save_folder_if_nonexistent()}}
\item \href{#method-rename_save_folder}{\code{ffexp$rename_save_folder()}}
\item \href{#method-delete_save_folder_if_empty}{\code{ffexp$delete_save_folder_if_empty()}}
\item \href{#method-recover_parallel_temp_save}{\code{ffexp$recover_parallel_temp_save()}}
\item \href{#method-rungrid2}{\code{ffexp$rungrid2()}}
\item \href{#method-add_variable}{\code{ffexp$add_variable()}}
\item \href{#method-add_level}{\code{ffexp$add_level()}}
\item \href{#method-print}{\code{ffexp$print()}}
\item \href{#method-set_parallel_cores}{\code{ffexp$set_parallel_cores()}}
\item \href{#method-stop_cluster}{\code{ffexp$stop_cluster()}}
\item \href{#method-finalize}{\code{ffexp$finalize()}}
\item \href{#method-clone}{\code{ffexp$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Create an `ffexp` object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$new(
  ...,
  eval_func,
  save_output = FALSE,
  parallel = FALSE,
  parallel_cores = "detect",
  folder_path,
  varlist = NULL,
  verbose = 2
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Input arguments for the experiment}

\item{\code{eval_func}}{The function to be run. It must take
named arguments matching the names of ...}

\item{\code{save_output}}{Should output be saved to file?}

\item{\code{parallel}}{Should a parallel cluster be used?}

\item{\code{parallel_cores}}{When running in parallel, how many cores should
be used. Not actually the number of cores used, actually the number
of clusters created. Can be more than the computer has available,
but will hurt performance. Can set to 'detect' to have it detect
how many cores are available and use that, or 'detect-1' to use
one fewer than there are.}

\item{\code{folder_path}}{Where the data and files should be stored.
If not given, a folder in the existing directory will be created.}

\item{\code{varlist}}{Character vector of names of objects that need to be
passed to the parallel environment.}

\item{\code{verbose}}{How much should be printed when running. 0 is none,
2 is average.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_all"></a>}}
\if{latex}{\out{\hypertarget{method-run_all}{}}}
\subsection{Method \code{run_all()}}{
Run an experiment. The user can choose
to run all rows, or just specified ones, if it should
be run in parallel, and what files should be saved.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$run_all(
  to_run = NULL,
  random_n = NULL,
  redo = FALSE,
  run_order,
  save_output = self$save_output,
  parallel = self$parallel,
  parallel_cores = self$parallel_cores,
  parallel_temp_save = save_output,
  write_start_files = save_output,
  write_error_files = save_output,
  delete_parallel_temp_save_after = FALSE,
  varlist = self$varlist,
  verbose = self$verbose,
  outfile,
  warn_repeat = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{to_run}}{Which rows should be run? If NULL, then all that haven't
been run yet.}

\item{\code{random_n}}{Randomly selects n trials among those not yet completed
and runs them.}

\item{\code{redo}}{Should already completed rows be run again?}

\item{\code{run_order}}{In what order should the rows by run?
Options: random, in_order, and reverse.}

\item{\code{save_output}}{Should the output be saved?}

\item{\code{parallel}}{Should it be run in parallel?}

\item{\code{parallel_cores}}{When running in parallel, how many cores should
be used. Not actually the number of cores used, actually the number
of clusters created. Can be more than the computer has available,
but will hurt performance. Can set to 'detect' to have it detect
how many cores are available and use that, or 'detect-1' to use
one fewer than there are.}

\item{\code{parallel_temp_save}}{Should temp files be written when running
in parallel? Prevents losing results if it crashes partway through.}

\item{\code{write_start_files}}{Should start files be written?}

\item{\code{write_error_files}}{Should error files be written for rows that
fail?}

\item{\code{delete_parallel_temp_save_after}}{If using parallel temp save
files, should they be deleted afterwards?}

\item{\code{varlist}}{A character vector of names of variables to be passed
the the parallel cluster.}

\item{\code{verbose}}{How much should be printed when running. 0 is none,
2 is average.}

\item{\code{outfile}}{Where should master output file be saved when running
in parallel?}

\item{\code{warn_repeat}}{Should warnings be given when repeating already
completed rows?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_for_time"></a>}}
\if{latex}{\out{\hypertarget{method-run_for_time}{}}}
\subsection{Method \code{run_for_time()}}{
Run the experiment for a given time, not for a specified
number of trials. Runs `batch_size` trials between checking the time
elapsed, only needs to be more than 1 when running in parallel.
It will complete the current batch before stopping, it does not quit
in the middle of the batch when reaching the time limit, so it will
go over the time limit given.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$run_for_time(
  sec,
  batch_size,
  show_time_in_bar = FALSE,
  save_output = self$save_output,
  parallel = self$parallel,
  parallel_cores = self$parallel_cores,
  parallel_temp_save = save_output,
  write_start_files = save_output,
  write_error_files = save_output,
  delete_parallel_temp_save_after = FALSE,
  varlist = self$varlist,
  verbose = self$verbose,
  warn_repeat = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{sec}}{Number of seconds to run for}

\item{\code{batch_size}}{Number of trials to run between checking the time
elapsed.}

\item{\code{show_time_in_bar}}{The progress bar can show either the number of
runs completed or the time elapsed.}

\item{\code{save_output}}{Should the output be saved?}

\item{\code{parallel}}{Should it be run in parallel?}

\item{\code{parallel_cores}}{When running in parallel, how many cores should
be used. Not actually the number of cores used, actually the number
of clusters created. Can be more than the computer has available,
but will hurt performance. Can set to 'detect' to have it detect
how many cores are available and use that, or 'detect-1' to use
one fewer than there are.}

\item{\code{parallel_temp_save}}{Should temp files be written when running
in parallel? Prevents losing results if it crashes partway through.}

\item{\code{write_start_files}}{Should start files be written?}

\item{\code{write_error_files}}{Should error files be written for rows that
fail?}

\item{\code{delete_parallel_temp_save_after}}{If using parallel temp save
files, should they be deleted afterwards?}

\item{\code{varlist}}{A character vector of names of variables to be passed
the the parallel cluster.}

\item{\code{verbose}}{How much should be printed when running. 0 is none,
2 is average.}

\item{\code{warn_repeat}}{Should warnings be given when repeating already
completed rows?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_superbatch"></a>}}
\if{latex}{\out{\hypertarget{method-run_superbatch}{}}}
\subsection{Method \code{run_superbatch()}}{
Run batches. Allows for better progress visualization
and saving when running in parallel
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$run_superbatch(
  nsb,
  redo = FALSE,
  run_order,
  save_output = self$save_output,
  parallel = self$parallel,
  parallel_cores = self$parallel_cores,
  parallel_temp_save = save_output,
  write_start_files = save_output,
  write_error_files = save_output,
  delete_parallel_temp_save_after = FALSE,
  varlist = self$varlist,
  verbose = self$verbose,
  warn_repeat = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{nsb}}{Number of super batches}

\item{\code{redo}}{Should already completed rows be run again?}

\item{\code{run_order}}{In what order should the rows by run?
Options: random, in_order, and reverse.}

\item{\code{save_output}}{Should the output be saved?}

\item{\code{parallel}}{Should it be run in parallel?}

\item{\code{parallel_cores}}{When running in parallel, how many cores should
be used. Not actually the number of cores used, actually the number
of clusters created. Can be more than the computer has available,
but will hurt performance. Can set to 'detect' to have it detect
how many cores are available and use that, or 'detect-1' to use
one fewer than there are.}

\item{\code{parallel_temp_save}}{Should temp files be written when running
in parallel? Prevents losing results if it crashes partway through.}

\item{\code{write_start_files}}{Should start files be written?}

\item{\code{write_error_files}}{Should error files be written for rows that
fail?}

\item{\code{delete_parallel_temp_save_after}}{If using parallel temp save
files, should they be deleted afterwards?}

\item{\code{varlist}}{A character vector of names of variables to be passed
the the parallel cluster.}

\item{\code{verbose}}{How much should be printed when running. 0 is none,
2 is average.}

\item{\code{warn_repeat}}{Should warnings be given when repeating already
completed rows?}

\item{\code{outfile}}{Where should master output file be saved when running
in parallel?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-run_one"></a>}}
\if{latex}{\out{\hypertarget{method-run_one}{}}}
\subsection{Method \code{run_one()}}{
Run a single row of the experiment.
You can specify which one to run.
Generally this should not be used by users, use `run_all`
instead.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$run_one(
  irow = NULL,
  save_output = self$save_output,
  write_start_files = save_output,
  write_error_files = save_output,
  warn_repeat = TRUE,
  is_parallel = FALSE,
  return_list_result_of_one = FALSE,
  verbose = self$verbose
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{irow}}{Which row should be run?}

\item{\code{save_output}}{Should the output be saved?}

\item{\code{write_start_files}}{Should a file be written when starting
the experiment?}

\item{\code{write_error_files}}{Should a file be written if there is
an error?}

\item{\code{warn_repeat}}{Should a warning be given if repeating a row?}

\item{\code{is_parallel}}{Is this being run in parallel?}

\item{\code{return_list_result_of_one}}{Should the list of the result of
this one be return?}

\item{\code{verbose}}{How much should be printed when running. 0 is none,
2 is average.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_result_of_one"></a>}}
\if{latex}{\out{\hypertarget{method-add_result_of_one}{}}}
\subsection{Method \code{add_result_of_one()}}{
Add the result of a single experiment to the object.
This shouldn't be used by users.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$add_result_of_one(
  output,
  systime,
  irow,
  row_grid,
  row_df,
  start_time,
  end_time,
  save_output
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output}}{The output of the experiment.}

\item{\code{systime}}{The time it took to run}

\item{\code{irow}}{The row of inputs used.}

\item{\code{row_grid}}{The corresponding row in the run grid.}

\item{\code{row_df}}{The corresponding row data frame.}

\item{\code{start_time}}{The start time of the experiment.}

\item{\code{end_time}}{The end time of the experiment.}

\item{\code{save_output}}{Should the output be saved?}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_run_times"></a>}}
\if{latex}{\out{\hypertarget{method-plot_run_times}{}}}
\subsection{Method \code{plot_run_times()}}{
Plot the run times of each trial.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$plot_run_times()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_pairs"></a>}}
\if{latex}{\out{\hypertarget{method-plot_pairs}{}}}
\subsection{Method \code{plot_pairs()}}{
Plot pairs of inputs and outputs.
Helps see correlations and distributions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$plot_pairs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
Calling `plot` on an `ffexp` object calls `plot_pairs()`
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$plot()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-calculate_effects"></a>}}
\if{latex}{\out{\hypertarget{method-calculate_effects}{}}}
\subsection{Method \code{calculate_effects()}}{
Calculate the effects of each variable as if this
was an experiment using a linear model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$calculate_effects()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-calculate_effects2"></a>}}
\if{latex}{\out{\hypertarget{method-calculate_effects2}{}}}
\subsection{Method \code{calculate_effects2()}}{
Calculate the effects of each variable as if this
was an experiment using a linear model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$calculate_effects2()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-save_self"></a>}}
\if{latex}{\out{\hypertarget{method-save_self}{}}}
\subsection{Method \code{save_self()}}{
Save this R6 object
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$save_self(verbose = self$verbose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{How much should be printed when running. 0 is none,
2 is average.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-create_save_folder_if_nonexistent"></a>}}
\if{latex}{\out{\hypertarget{method-create_save_folder_if_nonexistent}{}}}
\subsection{Method \code{create_save_folder_if_nonexistent()}}{
Create the save folder if it doesn't already exist.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$create_save_folder_if_nonexistent()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rename_save_folder"></a>}}
\if{latex}{\out{\hypertarget{method-rename_save_folder}{}}}
\subsection{Method \code{rename_save_folder()}}{
Rename the save folder
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$rename_save_folder(new_folder_path, new_folder_name)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{new_folder_path}}{New path for the save folder}

\item{\code{new_folder_name}}{If you want the new save folder to be in the
current directory, you can use this instead of `new_folder_path` and
just give the folder name.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-delete_save_folder_if_empty"></a>}}
\if{latex}{\out{\hypertarget{method-delete_save_folder_if_empty}{}}}
\subsection{Method \code{delete_save_folder_if_empty()}}{
Delete the save folder if it is empty.
Used to prevent leaving behind empty folders.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$delete_save_folder_if_empty(verbose = self$verbose)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{verbose}}{How much should be printed when running. 0 is none,
2 is average.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-recover_parallel_temp_save"></a>}}
\if{latex}{\out{\hypertarget{method-recover_parallel_temp_save}{}}}
\subsection{Method \code{recover_parallel_temp_save()}}{
Running this loads the information saved to files
if `save_parallel_temp_save=TRUE` was used when running.
Useful when running long jobs in parallel so that you don't
lose all results if it crashes before finishing.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$recover_parallel_temp_save(delete_after = FALSE, only_reload_new = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{delete_after}}{Should the temp files be deleted after they
are recovered? If TRUE, make sure you save the ffexp object after
running this function so
you don't lose the data.}

\item{\code{only_reload_new}}{Will only reload output from runs that don't show as
completed yet. Can make it much faster if there are many saved files, but
most have already been loaded to this object.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-rungrid2"></a>}}
\if{latex}{\out{\hypertarget{method-rungrid2}{}}}
\subsection{Method \code{rungrid2()}}{
Display the input rows of the experiment.
rungrid just gives integers, this gives the actual values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$rungrid2(rows = 1:nrow(self$rungrid))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{rows}}{Which rows to display the inputs for? On big
experiments, specifying the rows can be much faster.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_variable"></a>}}
\if{latex}{\out{\hypertarget{method-add_variable}{}}}
\subsection{Method \code{add_variable()}}{
Add a variable to the experiment. You must specify the
value of the variable for all existing rows, and then also the values
of the variable which haven't been run yet.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$add_variable(name, existing_value, new_values, suppressMessage = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{name}}{Name of the variable being added.}

\item{\code{existing_value}}{Which existing argument is a level being added to?}

\item{\code{new_values}}{The values of the new variable which have not been
run. This should not include `arg_name`, the name of the new variable
at the existing values.}

\item{\code{suppressMessage}}{Should the message be suppressed? The message
tells the user a new variable was added and it is being returned in a new
object. Default FALSE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-add_level"></a>}}
\if{latex}{\out{\hypertarget{method-add_level}{}}}
\subsection{Method \code{add_level()}}{
Add a level to one of the arguments. This returns a new
object. The existing object is not changed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$add_level(arg_name, new_values, suppressMessage = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{arg_name}}{Which existing argument is a level being added to?}

\item{\code{new_values}}{The value of the new levels to be added to `arg_name`.}

\item{\code{suppressMessage}}{Should the message be suppressed? The message
tells the user a new level was added and it is being returned in a new
object. Default FALSE.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-print"></a>}}
\if{latex}{\out{\hypertarget{method-print}{}}}
\subsection{Method \code{print()}}{
Printing the object shows some
summary information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$print()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-set_parallel_cores"></a>}}
\if{latex}{\out{\hypertarget{method-set_parallel_cores}{}}}
\subsection{Method \code{set_parallel_cores()}}{
Set the number of parallel cores to be used when
running in parallel. Needed in case user sets "detect"
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$set_parallel_cores(parallel_cores)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{parallel_cores}}{When running in parallel, how many cores should
be used. Not actually the number of cores used, actually the number
of clusters created. Can be more than the computer has available,
but will hurt performance. Can set to 'detect' to have it detect
how many cores are available and use that, or 'detect-1' to use
one fewer than there are.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-stop_cluster"></a>}}
\if{latex}{\out{\hypertarget{method-stop_cluster}{}}}
\subsection{Method \code{stop_cluster()}}{
Stop the parallel cluster.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$stop_cluster()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-finalize}{}}}
\subsection{Method \code{finalize()}}{
Cleanup after deleting object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$finalize()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ffexp$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
