% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mbc_clean.R
\name{mbc}
\alias{mbc}
\title{Model benchmark compare}
\usage{
mbc(..., times = 5, input, inputi, evaluator, post, target, targetin,
  metric = "rmse", paired, kfold)
}
\arguments{
\item{...}{Functions to run}

\item{times}{Number of times to run}

\item{input}{Object to be passed as input to each function}

\item{inputi}{Function to be called with the replicate number then passed to each function.}

\item{evaluator}{An expression that the ... expressions will be passed as "." for evaluation.}

\item{post}{Function or expression (using ".") to post-process results.}

\item{target}{Values the functions are expected to (approximately) return.}

\item{targetin}{Values that will be given to the result of the run to produce output.}

\item{metric}{c("rmse", "t", "mis90", "sr27") Metric used to compare output values to target.
mis90 is the mean interval score for 90\% confidence, see Gneiting and Raftery (2007).
sr27 is the scoring rule given in Equation 27 of Gneiting and Raftery (2007).}

\item{paired}{Should the results be paired for comparison?}

\item{kfold}{First element should be the number of elements that are being
split into groups. If the number of folds is different from `times`, then
the second argument is the number of folds.
Use `ki` in `inputi` and `targeti` to select elements in the current fold.}
}
\value{
Data frame of comparison results
}
\description{
Compare the run time and output of various code chunks
}
\examples{
# Compare distribution of mean for different sample sizes
mbc(mean(rnorm(1e2)),
    mean(rnorm(1e4)),
    times=20)

# Compare mean and median on same data
mbc(mean(x),
    median(x),
    inputi={x=rexp(1e2)})

# input given, no post
mbc({Sys.sleep(rexp(1, 30));mean(x)},
     {Sys.sleep(rexp(1, 5));median(x)},
    inputi={x=runif(100)})

# input given with post
mbc(mean={Sys.sleep(rexp(1, 30));mean(x)},
    med={Sys.sleep(rexp(1, 5));median(x)},
    inputi={x=runif(100)},
    post=function(x){c(x+1, x^2)})

# input given with post, 30 times
mbc(mean={Sys.sleep(rexp(1, 30));mean(x)+runif(1)},
    med={Sys.sleep(rexp(1, 50));median(x)+runif(1)},
    inputi={x=runif(100)},
    post=function(x){c(x+1, x^2)}, times=10)

# Name one function and post
mbc({mean(x)+runif(1)},
    a1={median(x)+runif(1)},
    inputi={x=runif(100)},
    post=function(x){c(rr=x+1, gg=x^2)}, times=10)

# No input
m1 <- mbc(mean={x <- runif(100);Sys.sleep(rexp(1, 30));mean(x)},
          med={x <- runif(100);Sys.sleep(rexp(1, 50));median(x)})
}
\references{
Gneiting, T., & Raftery, A. E. (2007). Strictly proper scoring rules, prediction, and estimation. Journal of the American Statistical Association, 102(477), 359-378.
}
