% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_diag.R
\name{sample_diag}
\alias{sample_diag}
\title{Simulate ICD-10 and ICD-9 diagnostic codes}
\usage{
sample_diag(n = 1, version = "ICD10_2011")
}
\arguments{
\item{n}{Number of ICD codes to simulate.}

\item{version}{The version of the ICD coding scheme to use. Possible choices are \code{ICD10_2009}, \code{ICD10_2011}, and \code{ICD9_2015}; defaults to \code{ICD10_2011}. See \link{icd10_2009}, \link{icd10_2011}, and \link{icd9_2015} for further information on the different schemes.}
}
\value{
A vector of \code{n} ICD diagnostic codes.
}
\description{
A simple function to simulate ICD-10 and ICD-9 diagnostic codes at random.
}
\examples{
# Simulate 10 ICD-10 codes
sample_diag(10)

# Simulate a tidy dataset with 15 individuals and 200 rows
set.seed(1)
x <- data.frame(
  id = sample(1:15, size = 200, replace = TRUE),
  code = sample_diag(n = 200),
  stringsAsFactors = FALSE
)
head(x)
}
