% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/other_functions.R
\name{find.names}
\alias{find.names}
\title{Search for names}
\usage{
find.names(
  x,
  pattern = NULL,
  exclude = NULL,
  start = NULL,
  end = NULL,
  ignore.case = TRUE
)
}
\arguments{
\item{x}{A data frame or tibble whose names to search.  Parameter also
accepts a character vector of names.}

\item{pattern}{A vector of patterns to search for. The asterisk (*)
and question mark (?) characters may be used to indicate partial matches.}

\item{exclude}{A vector of patterns to exclude from the search results.
The asterisk (*)
and question mark (?) characters may be used to indicate partial matches.}

\item{start}{A variable name or position to start the search. Default is 1.}

\item{end}{A variable name or position to end the search. Default is the
length of the name vector.}

\item{ignore.case}{Whether to perform a case sensitive or insensitive
search.  Valid values are TRUE and FALSE. Default is TRUE.}
}
\value{
A vector of variable names that met the search criteria.
}
\description{
A function to search for variable names in a data.frame or tibble.
The function features wild card pattern matching, start and end
boundaries, and names to exclude.
}
\examples{
# Show all names for reference
names(mtcars)
#  [1] "mpg"  "cyl"  "disp" "hp"   "drat" "wt"   "qsec" "vs"   "am"   "gear" "carb"

# Names that start with "c"
find.names(mtcars, "c*")
# [1] "cyl"  "carb"

# Names that start with "c" or "d"
find.names(mtcars, c("c*", "d*"))
# [1] "cyl"  "carb" "disp" "drat"

# Names between "disp" and "qsec"
find.names(mtcars, start = "disp", end = "qsec")
# [1] "disp" "hp"   "drat" "wt"   "qsec"

# Names that start with "c" or "d" after position 5
find.names(mtcars, c("c*", "d*"), start = 5)
# [1] "carb" "drat"

# Names between "disp" and "qsec" excluding "wt"
find.names(mtcars, start = "disp", end = "qsec", exclude = "wt")
# [1] "disp" "hp"   "drat" "qsec"
}
