% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cutTSV.r
\name{cutTSV}
\alias{cutTSV}
\title{Categorizing Thermal Sensation Votes}
\usage{
cutTSV(pred)
}
\arguments{
\item{pred}{a numeric item or vector containing continuous thermal sensation 
votes coded from -3 'cold' to +3 'hot'}
}
\value{
\code{cutTSV} returns an item or a vector with categorical thermal 
sensation votes.
}
\description{
\code{cutTSV} converts continuous thermal sensation votes to 
categorical ones.
}
\details{
Categorization is realized with intervals closed on the right, e.g. 
setting all values lower and equal then -2.5 to a value of -3, higher than 
-2.5 and lower or equal -1.5 to -2, and so on.
}
\examples{
## define example data
pred <- rnorm(5)
## bin values
cutTSV(pred)
}
\author{
Marcel Schweiker
}
\keyword{manip}
