% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcPMV.R
\name{calcPMV}
\alias{calcPMV}
\alias{pmv}
\title{Predicted Mean Votes (PMV)}
\usage{
calcPMV(ta, tr, vel, rh, clo=.5, met=1, wme=0, basMet=58.15)
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}

\item{met}{a numeric value presenting metabolic rate in [met]}

\item{wme}{a numeric value presenting external work in [met]}

\item{basMet}{a numeric value presenting basal metabolic rate [w/m2]}
}
\value{
PMV - Predicted Mean Vote
}
\description{
Function to calculate Predicted Mean Vote (PMV).
}
\details{
The PMV is an index that predicts the mean value of the thermal sensation of a large group of people on a sensation scale expressed from (-3) to (+3) corresponding to the categories cold, cool, slightly cool, neutral, slightly warm, warm and hot. PMV model is limited to air speeds below 0.20 m/s.

Note that the adjustments in the value for basMet need to be made with great cautiousness as the PMV calculation is an empirical model and might not be valid for other values of basMet than the one commonly used.
}
\examples{
calcPMV(25,25,0.3,50,0.5,1)
}
\references{
Fanger (1970) Thermal Comfort Analysis and Applications in Environmental Engineering McGraw-Hill, New York.

ISO 7730 (2005) Ergonomics of the thermal environment analytical determination and interpretation of thermal comfort using calculation of the pmv and ppd indices and local thermal comfort criteria.
}
\author{
Code implemented in to R by Marcel Schweiker. Further contribution by Sophia Mueller and Shoaib Sarwar.
}
