% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcCE.R
\name{calcCE}
\alias{calcCE}
\alias{coolingeffect}
\alias{ce}
\title{Cooling Effect}
\usage{
calcCE(ta, tr, vel, rh, clo = 0.5, met = 1, wme = 0)
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}

\item{met}{a numeric value presenting metabolic rate in [met]}

\item{wme}{a numeric value presenting external work in [met]}
}
\value{
ce - Cooling Effect in [degree C]
}
\description{
Function to calculate cooling effect (CE) of elevated air velocities using the standard effective temperature (SET).
}
\details{
The CE of the elevated air velocity is the difference in SET between conditions with given air velocities and still air. The cooling effect should be calculated only for air velocities higher than 0.2 m/s.
}
\examples{
calcCE(25,25,0.3,50,0.5,1) # returns Cooling Effect: 1.3
}
\references{
Original code in Python by Tartarini & Schiavon (2020) <doi:10.1016/j.softx.2020.100578>
}
\author{
Code implemented in to R by Shoaib Sarwar. Further contribution by Marcel Schweiker.
}
