% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_incoma.R
\name{get_incoma}
\alias{get_incoma}
\title{Create an integrated co-occurrence matrix (wecoma)}
\usage{
get_incoma(x, neighbourhood = 4)
}
\arguments{
\item{x}{A RasterStack object containing categorical rasters}

\item{neighbourhood}{The number of directions in which cell adjacencies are considered as neighbours:
4 (rook's case) or 8 (queen's case). The default is 4.}
}
\value{
An integrated co-occurrence matrix
}
\description{
Create an integrated co-occurrence matrix (wecoma)
}
\examples{
library(raster)

l1 = raster(matrix(sample(1:2, size = 100, replace = TRUE), ncol = 10))
l2 = raster(matrix(sample(c(9, 6, 3), size = 100, replace = TRUE), ncol = 10))
x = stack(l1, l2, l1)

get_incoma(x)

}
