% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clpng.r
\name{clpng}
\alias{clpng}
\alias{clpie}
\alias{plot.clcolor}
\alias{plot.clcolors}
\alias{plot.clpalette}
\alias{plot.clpalettes}
\alias{plot.clpattern}
\alias{plot.clpatterns}
\title{Plot a COLOURlovers object}
\usage{
clpng(x, ...)

clpie(x, ...)

\method{plot}{clcolor}(x, type = "png", ...)
}
\arguments{
\item{x}{A colourlovers color, palette, or pattern object.}

\item{\dots}{Ignored.}

\item{type}{One of \dQuote{png} (the default) or \dQuote{pie}.}
}
\value{
The \code{x} object is invisibly returned.
}
\description{
Plot a color, palette, or pattern color pie or PNG image in a plotting
device
}
\details{
Plot a colourlovers PNG image in a new plotting window.
}
\examples{
\dontrun{
# Plot a color clpng
co <- clcolor(rgb(0,0,1))
plot(co)

# Plot a pattern clpng
p <- clpattern('1451')
plot(p)
clpng(p)

# Plot colors from a palette
p <- clpalette('113451')
plot(p, type = 'pie')
clpie(p)

# Plot multiple palettes (interactively)
p <- clpalettes('top')
plot(p) #  PNG images
plot(p, type = 'pie')  # pie chart swatches
}

}
\author{
Thomas J. Leeper
}
