% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colorpatch_impl.R
\name{FindUniformSequence}
\alias{FindUniformSequence}
\title{Finds a uniform color sequence within a non-uniform palette by subsampling that palette}
\usage{
FindUniformSequence(P, n.out, reverse = FALSE, delta = NULL,
  col.dist.fun = DistColorFun("LAB"))
}
\arguments{
\item{P}{input color palette (must be a class derived from \link[colorspace:color-class]{colorspace::color})}

\item{n.out}{number of output colors (must be less than length(P))}

\item{reverse}{shall the searching be performed from the end of the palette to the beginning}

\item{delta}{the perceptual difference to be achieved between two adjecent colors}

\item{col.dist.fun}{function mapping two colors to a numeric distance}
}
\value{
a optimized palette (sub-set of P)
}
\description{
Finds a uniform color sequence within a non-uniform palette by subsampling that palette
}
