% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helpers.R
\name{.intensity_get}
\alias{.intensity_get}
\title{Get pixel intensities}
\usage{
.intensity_get(img, ind = c(1, 2))
}
\arguments{
\item{img}{An object of class \code{\link[imager]{cimg}}}

\item{ind}{A \code{numeric} of length two for channel indexes}
}
\value{
A \code{list} of three items. The first two items are the values of
the pixel intensities of the channels indicated by \code{ind}. The third is
the labels of the individual regions of interest.
}
\description{
Get the pixel intensities of certain image channels
}
\examples{
# load image
fl <- system.file('extdata', 'Image0001_.jpg', package = 'colocr')
img <- image_load(fl)

# choose parameters
int <- roi_select(img, threshold = 90) \%>\%
  .intensity_get()

}
