% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointReg-D-OLS.R
\name{makeLeadLagMatrix}
\alias{makeLeadLagMatrix}
\title{Leads-and-Lags Matrix}
\usage{
makeLeadLagMatrix(x, n.lag, n.lead)
}
\arguments{
\item{x}{[\code{matrix}]\cr
Matrix for which to generate the leads-and-lags matrix.}

\item{n.lag, n.lead}{[\code{numeric(1)}]\cr
Number of lags and leads, have to be non-negative integer values.
If greater than \code{nrow(x)}, produces 0-rows.}
}
\value{
[\code{matrix}]. Leads-and-lags matrix.
}
\description{
Generates leads-and-lags matrix for the Dynamic OLS estimator.
}
\examples{
x <- matrix(1:20, 2, byrow = TRUE)
cointReg:::makeLeadLagMatrix(x = x, n.lag = 2, n.lead = 3)
}
\seealso{
Other D-OLS: \code{\link{cointRegD}},
  \code{\link{getLeadLag}}, \code{\link{getModD}}
}

