% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/list_operators.R
\name{.get_item}
\alias{.get_item}
\title{Return list of objects matching provided condition.}
\usage{
.get_item(list_obj, attribute, value, operator = `==`)
}
\arguments{
\item{list_obj}{List of R objects.}

\item{attribute}{Object attribute name.}

\item{value}{Object value.}

\item{operator}{Logical operator - two-argument function taking `list_obj` attribute
value as the first one, and `value` as the second one.}
}
\value{
A subset of list object matching provided condition.
}
\description{
Return list of objects matching provided condition.
}
\examples{
my_list <- list(
  list(id = 1, name = "a"),
  list(id = 2, name = "b")
)
.get_item(my_list, "id", 1)
.get_item(my_list, "name", c("b", "c"), identical)

}
