% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StARS_coglasso.R
\name{stars_coglasso}
\alias{stars_coglasso}
\title{Stability selection of the best \code{coglasso} network}
\usage{
stars_coglasso(
  coglasso_obj,
  stars_thresh = 0.1,
  stars_subsample_ratio = NULL,
  rep_num = 20,
  max_iter = 10,
  verbose = TRUE
)
}
\arguments{
\item{coglasso_obj}{The object returned by \code{coglasso()}.}

\item{stars_thresh}{The threshold set for variability of the explored
networks at each iteration of the algorithm. The \eqn{\lambda_w} or the \eqn{\lambda_b}
associated to the most stable network before the threshold is overcome is
selected.}

\item{stars_subsample_ratio}{The proportion of samples in the multi-omics
data set to be randomly subsampled to estimate the variability of the
network under the given hyperparameters setting. Defaults to 80\% when the
number of samples is smaller than 144, otherwise it defaults to
\eqn{\frac{10}{n}\sqrt{n}}.}

\item{rep_num}{The amount of subsamples of the multi-omics data set used to
estimate the variability of the network under the given hyperparameters
setting. Defaults to 20.}

\item{max_iter}{The greatest number of times the algorithm is allowed to
choose a new best \eqn{\lambda_w}. Defaults to 10.}

\item{verbose}{Print information regarding the progress of the selection
procedure on the console.}
}
\value{
\code{stars_coglasso()} returns a list containing the results of the
selection procedure, built upon the list returned by \code{coglasso()}.
\itemize{
\item ... are the same elements returned by \code{\link[=coglasso]{coglasso()}}.
\item \code{merge_lw} and \code{merge_lb} are lists with as many elements as the number of
\eqn{c} parameters explored. Every element is in turn a list of as many
matrices as the number of \eqn{\lambda_w} (or \eqn{\lambda_b}) values explored. Each
matrix is the "merged" adjacency matrix, the average of all the adjacency
matrices estimated  for those specific \eqn{c} and \eqn{\lambda_w} (or \eqn{\lambda_b})
values across all the subsampling in the last path explored before
convergence, the one when the final combination of \eqn{\lambda_w} and \eqn{\lambda_b}
is selected for the given \eqn{c} value.
\item \code{variability_lw} and \code{variability_lb} are lists with as many elements as
the number of \eqn{c} parameters explored. Every element is a numeric vector
of as many items as the number of \eqn{\lambda_w} (or \eqn{\lambda_b}) values explored.
Each item is the variability of the network estimated for those specific
\eqn{c} and \eqn{\lambda_w} (or \eqn{\lambda_b}) values in the last path explored before
convergence, the one when the final combination of \eqn{\lambda_w} and \eqn{\lambda_b}
is selected for the given \eqn{c} value.
\item \code{opt_adj} is a list of the adjacency matrices finally selected for each
\eqn{c} parameter explored.
\item \code{opt_variability} is a numerical vector containing the variabilities
associated to the adjacency matrices in \code{opt_adj}.
\item \code{opt_index_lw} and \code{opt_index_lb} are integer vectors containing the
index of the selected \eqn{\lambda_w}s (or \eqn{\lambda_b}s) for each \eqn{c} parameters
explored.
\item \code{opt_lambda_w} and \code{opt_lambda_b} are vectors containing the selected
\eqn{\lambda_w}s (or \eqn{\lambda_b}s) for each \eqn{c} parameters explored.
\item \code{sel_index_c}, \code{sel_index_lw} and \code{sel_index_lb} are the indexes of the
final selected parameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b} leading to the
most stable sparse network.
\item \code{sel_c}, \code{sel_lambda_w} and \code{sel_lambda_b} are the final selected
parameters \eqn{c}, \eqn{\lambda_w} and \eqn{\lambda_b} leading to the most stable
sparse network.
\item \code{sel_adj} is the adjacency matrix of the final selected network.
\item \code{sel_density} is the density of the final selected network.
\item \code{sel_icov} is the inverse covariance matrix of the final selected network.
}
}
\description{
\code{stars_coglasso()} selects the combination of hyperparameters given to
\code{coglasso()} yielding the most stable, yet sparse network. Stability is
computed upon network estimation from subsamples of the multi-omics data set,
allowing repetition. Subsamples are collected for a fixed amount of times
(\code{rep_num}), and with a fixed proportion of the total number of samples
(\code{stars_subsample_ratio}).
}
\details{
\emph{StARS} for \emph{collaborative graphical regression} is an adaptation of the method
published by Liu, H. \emph{et al.} (2010): Stability Approach to Regularization
Selection (StARS). \emph{StARS} was developed for network estimation regulated by
a single penalty parameter, while collaborative graphical lasso needs to
explore three different hyperparameters. In particular, two of these are
penalty parameters with a direct influence on network sparsity, hence on
stability. For every \eqn{c} parameter, \code{stars_coglasso()} explores one of
the two penalty parameters (\eqn{\lambda_w} or \eqn{\lambda_b}), keeping the other one
fixed at its previous best estimate, using the normal, one-dimentional
\emph{StARS} approach, until finding the best couple. It then selects the \eqn{c}
parameter for which the best (\eqn{\lambda_w}, \eqn{\lambda_b}) couple yielded the most
stable, yet sparse network.
}
\examples{
cg <- coglasso(multi_omics_sd_micro, pX = 4, nlambda_w = 3, nlambda_b = 3, nc = 3, verbose = FALSE)
\donttest{
# Takes around 20 seconds
sel_cg <- stars_coglasso(cg, verbose = FALSE)
}
}
