% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_contrast_aggregated.R
\name{calc_contrast_aggregated}
\alias{calc_contrast_aggregated}
\title{Calculate between contrast analysis from aggregated data (means, sds and ns)}
\usage{
calc_contrast_aggregated(means, sds, ns, between, lambda_between, data)
}
\arguments{
\item{means}{numeric vector of mean values for every condition}

\item{sds}{numeric vector of standard deviation values for every condition}

\item{ns}{numeric vector of sample size values for every condition}

\item{between}{factor for the independent variable that divides the data into
independent groups}

\item{lambda_between}{numeric vector for contrast weights. Names must match
the levels of \code{between}. If \code{lambda_between} does not sum up to
zero, this will be done automatically (centering).}

\item{data}{optional argument for the \code{data.frame} containing all
variables except for lambda_between}
}
\value{
an object of type cofad_bw, including p-value, F-value, contrast
  weights, different effect sizes
}
\description{
Calculate between contrast analysis from aggregated data (means, sds and ns)
}
\examples{
library(dplyr)
furr_agg <- furr_p4 \%>\%
  group_by(major) \%>\%
  summarize(mean = mean(empathy), sd = sd(empathy), n = n())
lambdas = c("psychology" = 1, "education" = -1, "business" = 0,
            "chemistry" = 0)
calc_contrast_aggregated(mean, sd, n, major, lambdas, furr_agg)

}
\references{
Rosenthal, R., Rosnow, R.L., & Rubin, D.B. (2000). Contrasts and
  effect sizes in behavioral research: A correlational approach. New York:
  Cambridge University Press.
}
