% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmarkdown_helpers.R
\name{asis_knit_child}
\alias{asis_knit_child}
\title{Knit a child document and output as is (render markup)}
\usage{
asis_knit_child(input = NULL, text = NULL, ..., quiet = TRUE,
  options = NULL, envir = parent.frame(), use_strings = TRUE)
}
\arguments{
\item{input}{if you specify a file path here, it will be read in before being passed to knitr (to avoid a working directory mess)}

\item{text}{passed to \code{\link[knitr:knit_child]{knitr::knit_child()}}}

\item{...}{passed to \code{\link[knitr:knit_child]{knitr::knit_child()}}}

\item{quiet}{passed to \code{\link[knitr:knit_child]{knitr::knit_child()}}}

\item{options}{defaults to NULL.}

\item{envir}{passed to \code{\link[knitr:knit_child]{knitr::knit_child()}}}

\item{use_strings}{whether to read in the child file as a character string (solves working directory problems but harder to debug)}
}
\description{
This slightly modifies the \code{\link[knitr:knit_child]{knitr::knit_child()}} function to have different defaults.
\itemize{
\item the environment defaults to the calling environment.
\item the output receives the class \code{knit_asis}, so that the output will be rendered "as is" by knitr when calling inside a chunk (no need to set \code{results='asis'} as a chunk option).
\item defaults to \code{quiet = TRUE}
}
}
\details{
Why default to the calling environment? Typically this function defaults to the global environment. This makes sense if you want to use knit children in the same context as the rest of the document.
However, you may also want to use knit children inside functions to e.g. summarise a regression using a set of commands (e.g. plot some diagnostic graphs and a summary for a regression nicely formatted).

Some caveats:
\itemize{
\item the function has to return to the top-level. There's no way to \code{\link[=cat]{cat()}} this from loops or an if-condition without without setting \code{results='asis'}. You can however concatenate these objects with \code{\link[=paste.knit_asis]{paste.knit_asis()}}
}
}
\examples{
\dontrun{
# an example of a wrapper function that calls asis_knit_child with an argument
# ensures distinct paths for cache and figures, so that these calls can be looped in parallel
regression_summary <- function(model) {
   hash <- digest::digest(model)
   options <- list(
       fig.path = paste0(knitr::opts_chunk$get("fig.path"), hash, "-"),
       cache.path = paste0(knitr::opts_chunk$get("cache.path"), hash, "-"))
   asis_knit_child("_regression_summary.Rmd", options = options)
}
}
}
