% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_longitudinal_functions.R
\name{filter_longitudinal}
\alias{filter_longitudinal}
\title{filter_longitudinal}
\usage{
filter_longitudinal(
  x,
  taxanames = NULL,
  x_time,
  subject_id,
  metadata,
  ini_time = min(x_time),
  end_time = max(x_time),
  percent_indv = 0.7,
  min_obs = 3
)
}
\arguments{
\item{x}{abundance table in long format (several rows per individual)}

\item{taxanames}{names of different taxa}

\item{x_time}{observation times}

\item{subject_id}{subject id}

\item{metadata}{matrix sample data}

\item{ini_time}{initial time to be analyzed}

\item{end_time}{end time to be analyzed}

\item{percent_indv}{percentage of individuals with more than min_obs observations}

\item{min_obs}{required minimum number of observations per individual}
}
\value{
list with filtered abundance table, taxanames and metadata
}
\description{
Filters those individuals and taxa with enough longitudinal information
}
\examples{

data(ecam_filtered, package = "coda4microbiome")   # load the data

x=x_ecam # microbiome abundance
x_time = metadata$day_of_life    # observation times
subject_id = metadata$studyid   # subject id
ini_time = 0
end_time = 360

data_filtered<-filter_longitudinal(x,taxanames,x_time, subject_id, metadata,
                                              ini_time, end_time, min_obs=4)


}
\author{
M. Calle - T. Susin
}
