% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coda4microbiome_functions.R
\name{logratios_matrix}
\alias{logratios_matrix}
\title{logratios_matrix}
\usage{
logratios_matrix(x)
}
\arguments{
\item{x}{abundance table  (rows are samples, columns are variables (taxa))}
}
\value{
list with matrix of log-ratios, matrix indicating the pairs of variables involved in each log-ratio,
and a matrix indicating the names of the variables involved in each log-ratio.
}
\description{
Computes a large matrix with all the log-ratios between pairs of taxa (columns) in the abundance table
}
\examples{

data(HIV, package = "coda4microbiome")

lrHIV<-logratios_matrix(x_HIV[,(1:4)])

# matrix of log-ratios (first 6 rows and 6 columns):

lrHIV[[1]][1:6,1:6]

# variables involved in each log-ratio

head(lrHIV[[2]])

# names of the variables involved in each log-ratio

head(lrHIV[[3]])

}
\author{
M. Calle - T. Susin
}
