% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coordinates.R
\name{pb_basis}
\alias{pb_basis}
\title{Compute a basis for considering Principal Balances.}
\usage{
pb_basis(X, method, rep = ceiling(ncol(X)/2), ...)
}
\arguments{
\item{X}{compositional dataset}

\item{method}{method to be used with Principal Balances. Methods available are: 'lsearch' or
method to be passed to hclust function (for example `ward.D` or `ward.D2` to use Ward method).}

\item{rep}{Number of restartings to be used with the local search algorithm.}

\item{...}{parameters passed to hclust function}
}
\value{
matrix
}
\description{
Compute a basis for considering Principal Balances.
}
\examples{
X = matrix(exp(rnorm(10*100)), nrow=100, ncol=10)
# Optimal variance obtained with Principal components
apply(coordinates(X, 'pc'), 2, var)
# Solution obtained using local search
apply(coordinates(X,pb_basis(X, method='lsearch')), 2, var)
# Solution obtained using Ward method
apply(coordinates(X,pb_basis(X, method='ward.D2')), 2, var)
# Solution obtained using Old Ward function (in R versions <= 3.0.3)
apply(coordinates(X,pb_basis(X, method='ward.D')), 2, var)
}
