% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_stats.R
\name{format_stats.easycorrelation}
\alias{format_stats.easycorrelation}
\title{Format correlation statistics}
\usage{
\method{format_stats}{easycorrelation}(
  x,
  digits = 2,
  pdigits = 3,
  pzero = FALSE,
  full = TRUE,
  italics = TRUE,
  type = "md",
  ...
)
}
\arguments{
\item{x}{An \code{htest} object}

\item{digits}{Number of digits after the decimal for means, confidence
intervals, and test statistics}

\item{pdigits}{Number of digits after the decimal for p-values, ranging
between 1-5 (also controls cutoff for small p-values)}

\item{pzero}{Logical value (default = FALSE) for whether to include
leading zero for p-values}

\item{full}{Logical value (default = TRUE) for whether to include means
and confidence intervals or just test statistic and p-value}

\item{italics}{Logical value (default = TRUE) for whether \emph{p} label should be
italicized}

\item{type}{Type of formatting ("md" = markdown, "latex" = LaTeX)}

\item{...}{Additional arguments passed to methods.}
}
\value{
A character string of statistical information formatted in Markdown or LaTeX.
}
\description{
This functions formats correlation statistics generated from the
\{\href{https://cran.r-project.org/package=correlation}{correlation}\} package.
This detects whether the object is from a Pearson, Spearman, or Kendall
correlation and reports the appropriate correlation label
(r, \eqn{\tau}, \eqn{\rho}). The default output is APA formatted, but
numbers of digits, leading zeros, the presence of confidence intervals,
and italics are all customizable.
}
\examples{
# Prepare statistical objects
test_corr <- correlation::correlation(mtcars, select = "mpg", select2 = "disp")
test_corr2 <- correlation::correlation(mtcars, select = "mpg", select2 = "disp", method = "kendall")

# Format correlation
format_stats(test_corr)

# Remove confidence intervals and italics
format_stats(test_corr, full = FALSE, italics = FALSE)

# Change digits and add leading zero to p-value
format_stats(test_corr, digits = 3, pdigits = 4, pzero = TRUE)

# Format Kendall's tau for LaTeX
format_stats(test_corr2, type = "latex")
}
\seealso{
Other functions for printing statistical objects: 
\code{\link{format_bf}()},
\code{\link{format_corr}()},
\code{\link{format_stats}()},
\code{\link{format_stats.BFBayesFactor}()},
\code{\link{format_stats.htest}()},
\code{\link{format_ttest}()}
}
\concept{functions for printing statistical objects}
