% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sumstat_seg_sites.R
\name{sumstat_seg_sites}
\alias{sumstat_seg_sites}
\title{Summary Statistic: Segregating Sites}
\usage{
sumstat_seg_sites(name = "seg_sites", transformation = identity)
}
\arguments{
\item{name}{The name of the summary statistic. When simulating a model,
the value of the statistics are written to an entry of the returned list
with this name. Summary statistic names must be unique in a model.}

\item{transformation}{An optional function for transforming the results
of the statistic. If specified, the results of the transformation are
returned instead of the original values.}
}
\value{
A list of \code{\link[=create_segsites]{segsites}} objects.
        These can be treated as a matrix for
        most applications. Rows are individuals, columns are SNPs.
}
\description{
This summary statistics generates a matrix of segregating sites.
This is useful for calculating summary statistics that \pkg{coala}
does not support..
}
\examples{
model <- coal_model(5, 1) +
  feat_mutation(5) +
  sumstat_seg_sites("segsites")
stats <- simulate(model)
print(stats$segsites)
}
\seealso{
For a description of the segregating sites class: \code{\link{create_segsites}}

To create a demographic model: \code{\link{coal_model}}

To calculate this statistic from data: \code{\link{calc_sumstats_from_data}}

Other summary statistics: 
\code{\link{sumstat_dna}()},
\code{\link{sumstat_file}()},
\code{\link{sumstat_four_gamete}()},
\code{\link{sumstat_ihh}()},
\code{\link{sumstat_jsfs}()},
\code{\link{sumstat_mcmf}()},
\code{\link{sumstat_nucleotide_div}()},
\code{\link{sumstat_omega}()},
\code{\link{sumstat_sfs}()},
\code{\link{sumstat_tajimas_d}()},
\code{\link{sumstat_trees}()}
}
\concept{summary statistics}
