% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulator_msms.R
\name{simulator_msms}
\alias{simulator_msms}
\alias{activate_msms}
\title{Simulator: msms}
\usage{
activate_msms(jar = NULL, java = NULL, priority = 200, download = FALSE)
}
\arguments{
\item{jar}{The path of the msms jar file.}

\item{java}{The path of the java executable on your system.}

\item{priority}{The priority for this simulator. If multiple simulators
can simulate a model, the one with the highest priority will be used.}

\item{download}{If set to \code{TRUE}, coala will try to download
the msms jar file. In that case, the \code{jar} argument
is not required.}
}
\description{
This adds the simulator 'msms' to the list of available simulators. To add
msms, you need to download the jar file and have Java installed on your
system.
}
\examples{
# Download and activate msms (requires Java)
\dontrun{activate_msms(download = TRUE)}
}
\references{
Gregory Ewing and Joachim Hermisson.
MSMS: a coalescent simulation program including recombination,
demographic structure and selection at a single locus.
Bioinformatics (2010) 26 (16): 2064-2065
doi:10.1093/bioinformatics/btq322
}
\seealso{
Other simulators: \code{\link{simulator_ms}},
  \code{\link{simulator_scrm}},
  \code{\link{simulator_seqgen}}
}
