\name{some}
\alias{some}
\alias{some.data.frame}
\alias{some.truthTab}

\title{
Randomly select configurations from a data frame or \code{truthTab}
}

\description{
Randomly select configurations from a data frame or \code{truthTab} by selecting a random sample with or without replacement.
}

\usage{
some(x, ...)

\method{some}{data.frame}(x, n = 10, replace = TRUE, ...)
\method{some}{truthTab}(x, n = 10, replace = TRUE, ...)
}

\arguments{
  \item{x}{A \code{truthTab}}
  \item{n}{Sample size}
  \item{replace}{Logical; if \code{TRUE}, configurations are sampled with replacement.}
  \item{\dots}{Not used}
}

\details{\code{some} randomly samples configurations from \code{x}. Such samples can, for instance, be used to simulate data fragmentation (limited diversity), i.e. the failure to observe/measure all configurations that are compatible with a data generating causal structure. They can also be used to simulate large-N data featuring multiple cases instantiating each configuration.
}

\value{
A data frame or truthTab.
}

\note{
The \code{some} generic function and the method for data frames are adopted from the \pkg{car} package. In particular, our \code{data.frame}-method has an additional argument \code{replace}, which is \code{TRUE} by default. It will by default not apply the same sampling scheme as the method in \pkg{car}.
}


\references{
Krook, Mona Lena. 2010.
\dQuote{Women's Representation in Parliament: A Qualitative Comparative Analysis.}
\emph{Political Studies} 58(5):886-908.

}


\seealso{\code{\link{truthTab}}, \code{\link{selectCases}}, \code{\link{allCombs}}, \code{\link{makeFuzzy}}, \code{\link{cna}}, \code{\link{d.women}}
}

\examples{
# Randomly sample configurations from the dataset analyzed by Krook (2010).
data(d.women)
tt.women <- truthTab(d.women)
some(tt.women, 20)
some(tt.women, 5, replace = FALSE)
some(tt.women, 5, replace = TRUE)

# Simulate limited diversity in data generated by the causal structure 
# A=2*B=1 + C=3*D=4 <-> E=3.
dat1 <- allCombs(c(3, 3, 4, 4, 3))
dat2 <- selectCases("A=2*B=1 + C=3*D=4 <-> E=3", dat1, type = "mv")
(dat3 <- some(dat2, 150, replace = TRUE))
mvcna(dat3)

# Simulate large-N fuzzy-set data generated by the common-cause structure
# (A*b*C + B*c <-> D) * (A*B + a*C <-> E).
dat1 <- allCombs(c(2, 2, 2, 2, 2)) - 1
dat2 <- selectCases("(A*b*C + B*c <-> D) * (A*B + a*C <-> E)", dat1)
dat3 <- some(dat2, 250, replace = TRUE)
dat4 <- makeFuzzy(tt2df(dat3), fuzzvalues = seq(0, 0.45, 0.01))
fscna(dat4, ordering = list(c("D", "E")), strict = TRUE, con = .8, cov = .8)
}