% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_climate.R
\name{monitor_climate}
\alias{monitor_climate}
\title{A 'cmsaf' extension for creating various climate plots.}
\usage{
monitor_climate(
  plot_type = "absolute_map",
  config = NULL,
  variable = NULL,
  accumulate = FALSE,
  mean_value = FALSE,
  infile = NULL,
  temp_dir = tempdir(),
  out_dir = getwd(),
  climate_dir = NULL,
  climate_year_start = 1983,
  climate_year_end = 2018,
  show_extreme_climate_years = NULL,
  climatology_until_eoy = FALSE,
  start_date = NULL,
  end_date = NULL,
  country_code = "S_A",
  lon_min = NULL,
  lon_max = NULL,
  lat_min = NULL,
  lat_max = NULL,
  outfile_name = NULL,
  output_format = "animation",
  animation_pace = 0.07,
  freeze_animation = FALSE,
  min_value = NULL,
  max_value = NULL,
  nbreaks = NULL,
  language = "eng",
  keep_files = TRUE,
  states = FALSE,
  attach = FALSE,
  infile_attach = "auto",
  analyze_method = TRUE,
  selected_number = 1,
  dwd_logo = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{plot_type}{Specifies the type of the plot
('absolute_map', 'anomaly_map', 'climatology_map', 'fieldmean_plot', 'fieldmean_and_anomaly_map').}

\item{config}{Path to YAML config file (character). The config file does not have
to specify all arguments. Each addressed argument has to be formatted according to the example config file: (#TODO: LINK EXAMPLE CONFIG FILE!).}

\item{variable}{Name of variable in infile (\code{NULL} or character). If \code{NULL} then the first variable from the infile is taken.}

\item{accumulate}{Whether the input file should be accumulated (logical).}

\item{mean_value}{Whether the input file should be averaged (logical).}

\item{infile}{Path to NetCDF file (\code{NULL} or character). If \code{NULL} then it needs to be specified in the config file.}

\item{temp_dir}{Path to temporary working directory (character).}

\item{out_dir}{Path to output directory (character).}

\item{climate_dir}{Path to directory in which climatology is computed or contained (\code{NULL} or character). If \code{NULL} then the temp_dir directory is taken.}

\item{climate_year_start}{Start year of climatology (integer).}

\item{climate_year_end}{End year of climatology (integer).}

\item{show_extreme_climate_years}{Whether the minimum and maximum of the climate years should be titled in the fieldmean plot (\code{NULL} or logical).
This is usually only of interest when plotting accumulated data. If the default \code{NULL} is chosen, then it will be set to the value of \code{accumulate}.}

\item{climatology_until_eoy}{Plot the climatology and fieldmeans until the end of year (logical). Only affects fieldmean plots analyzed from January 1st.}

\item{start_date}{Start date in format of 'YYYY-MM-DD' (\code{NULL} or character). If \code{NULL} then the first date of the infile is used.}

\item{end_date}{End date in format of 'YYYY-MM-DD' (\code{NULL} or character). If \code{NULL} then the last date of the infile is used.}

\item{country_code}{Either a country code in iso3c format or from the following: 'AFR' for Africa, 'EUR' for Europe, 'TOT' for the total disc,
or 'S_A' for an arbitrary region selection (character). If a country is passed the data from within this country is extracted,
else a rectangular box is visualized. Directly provided latitude and longitude ranges will be ignored in case of 'AFR', 'EUR' or 'TOT'.}

\item{lon_min}{Longitude of lower left corner (\code{NULL} or numeric). If \code{NULL} then the smallest longitude of the infile is used.}

\item{lon_max}{Longitude of upper right left corner (\code{NULL} or numeric). If \code{NULL} then the largest longitude of the infile is used.}

\item{lat_min}{Latitude of lower left corner (\code{NULL} or numeric). If \code{NULL} then the smallest latitude of the infile is used.}

\item{lat_max}{Latitude of upper right corner (\code{NULL} or numeric). If \code{NULL} then the largest latitude of the infile is used.}

\item{outfile_name}{Filename of the PNG or MP4 outfile (\code{NULL} or character).
If \code{NULL} then a name is computed from the current configuration.
Please match the file ending according to the output_format.}

\item{output_format}{Specification of output format (either 'graphic' for PNG or 'animation' for MP4).}

\item{animation_pace}{Pace of the animation in seconds (positive numeric). This only has an effect if \code{output_format == 'animation'}.}

\item{freeze_animation}{If TRUE then the animation will freeze at the last frame (logical).}

\item{min_value}{Lower values than this are ignored (\code{NULL} or numeric). If \code{NULL}, no values are ignored.}

\item{max_value}{Larger values than this are ignored (\code{NULL} or numeric). If \code{NULL}, no values are ignored.}

\item{nbreaks}{Number of color breaks (\code{NULL} or positive integer). A value will be computed if \code{NULL} is passed.}

\item{language}{Language used for title, legend, etc. in plots (either 'eng' for English or 'deu' for German).}

\item{keep_files}{A flag indicating whether all files created in the process of obtaining the output file should be kept (logical).
If false, all intermediate results are deleted, otherwise all are kept. Keeping these files could improve performance in further function calls.}

\item{states}{Whether to crop/plot administration level of states (logical).}

\item{attach}{Whether to temporaly merge the infile to an already existing one. (logical).}

\item{infile_attach}{File to attach the infile to. When 'auto', a suitable file will be searched in out_dir.
If attach is false, this will be ignored(character).}

\item{analyze_method}{Two analyze methods: mean == FALSE; accumulate == TRUE (logical) (Warming Stripes Plots, Time Series Plots, Trend Plots)}

\item{selected_number}{Timesteps of the same selected time range (Warming Stripes Plots, Time Series Plots, Trend Plots)}

\item{dwd_logo}{Whether to add the DWD logo (logical).}

\item{verbose}{Whether to display progress messages (logical).}
}
\description{
This plotting routine generates graphical output of the evolution of
the given variable within the given time range and area. The intended
application is for daily accumulated data, such as sunshine duration.
Dependent on the output format a PNG or MP4 is created.
}
\details{
You can pass a YAML config file and/or specify the arguments directly.
Argument prioritization is done in the following way:
Direct argument > config argument > default argument.
Thus, if you pass a existing config file but also want to modify a specific argument you can do that easily.
}
