% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polyinterp.R
\name{polyinterp}
\alias{polyinterp}
\title{Polynomial interpolation}
\usage{
polyinterp(x, y)
}
\arguments{
\item{x}{a vector of x values}

\item{y}{a vector of y values}
}
\value{
a polynomial equation's coefficients
}
\description{
Finds a polynomial function interpolating the given points
}
\details{
\code{polyinterp} finds a polynomial that interpolates the given points.
}
\examples{
x <- c(1, 2, 3)
y <- x^2 + 5 * x - 3
f <- polyinterp(x, y)

}
\seealso{
Other interp: \code{\link{bezier}}, \code{\link{bilinear}},
  \code{\link{cubicspline}}, \code{\link{linterp}},
  \code{\link{nn}}, \code{\link{pwiselinterp}}

Other algebra: \code{\link{bilinear}},
  \code{\link{cubicspline}}, \code{\link{division}},
  \code{\link{fibonacci}}, \code{\link{horner}},
  \code{\link{isPrime}}, \code{\link{linterp}},
  \code{\link{nthroot}}, \code{\link{pwiselinterp}},
  \code{\link{quadratic}}
}
