% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{setCutoff}
\alias{setCutoff}
\title{Set the cutoff for mediator selection}
\usage{
setCutoff(object, cutoff = 0.5)
}
\arguments{
\item{object}{a cmf object}

\item{cutoff}{either a number between 0 and 1 or "mc" - see details}
}
\value{
a cmf object with updated cutoff value
}
\description{
This function sets the cutoff value on a cmf object for mediator selection. 
Any cutoff value between 0 and 1 is allowed, where potential mediators with 
empirical selection probability (selection rate) above the cutoff will be 
considered mediators and the others will not. The cutoff can be entered 
manually or, when set to "mc", be based on a monte carlo simulation. See 
"details"
}
\details{
The monte carlo determination is based on a procedure in 
PCA and Factor Analysis called "Parallel Analysis". We generate data from
the null hypothesis with the same dimensionality as the original dataset and
perform the algorithm 100 times. This creates a distribution of nonmediator
selection rates from which we can determine the cutoff (the 99.9th 
percentile)
}
\examples{
# generate some data
dat <- generateMed(a = (1:10)/20, b = (1:10)/20)
res <- cmf(dat)
# set the cutoff for this result at 0.1
setCutoff(res, 0.1)

}
