% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cmahalanobis.R
\name{cmahalanobis}
\alias{cmahalanobis}
\title{Calculate the Mahalanobis distance for each species}
\usage{
cmahalanobis(
  dataset,
  plot = TRUE,
  p.value = FALSE,
  plot_title = "Mahalanobis Distance Between Groups"
)
}
\arguments{
\item{dataset}{A list of data frames, where each data frame contains the observations of a species.}

\item{plot}{Logical, if TRUE, a plot of the Mahalanobis distances is displayed.}

\item{p.value}{Logical, if TRUE, a matrix of p-values for the distances is returned.}

\item{plot_title}{The title to be used for the plot if plot is TRUE.}
}
\value{
A list containing a matrix with the Mahalanobis distances between each pair of groups, and optionally a matrix of p-values and the plot.
}
\description{
. This function takes a list of data frames as input, where each data frame contains the observations of a species, and returns a matrix with the Mahalanobis distances between each pair of species.
}
\examples{
# Example with the iris dataset
library(stats)
# Split the data into 3 parts for each species
setosa <- subset(iris, Species == "setosa")
setosa <- setosa[,-5]
versicolor <- subset(iris, Species == "versicolor")
versicolor <- versicolor[,-5]
virginica <- subset(iris, Species == "virginica")
virginica <- virginica[,-5]

# Create a list with the three groups of flowers
groups <- list(setosa, versicolor, virginica)

# Calculate the Mahalanobis distance with the cmahalanobis function
cmahalanobis(groups, plot = TRUE, p.value = FALSE, 
plot_title = "Mahalanobis Distance Between Groups")

ceuclide(groups, plot = TRUE, p.value = TRUE, 
plot_title = "Euclidean Distance Between Groups")
cmanhattan(groups, plot = TRUE, p.value = TRUE, 
plot_title = "Manhattan Distance Between Groups")
cchebyshev(groups, plot = TRUE, p.value = TRUE, 
plot_title = "Chebyshev Distance Between Groups")

# Example with the mtcars dataset
library(stats)
# Split the data into 2 parts for each type of transmission
auto <- subset(mtcars, am == 0)
auto <- auto[,-9]
manual <- subset(mtcars, am == 1)
manual <- manual[,-9]

# Create a list with the two groups of cars
groups <- list(auto, manual)

# Calculate the Mahalanobis distance with the cmahalanobis function
cmahalanobis(groups, plot = TRUE, p.value = TRUE, 
plot_title = "Mahalanobis Distance Between Groups")
ceuclide(groups, plot = TRUE, p.value = TRUE, num.permutations = 1000, 
plot_title = "Euclidean Distance Between Groups")
cmanhattan(groups, plot = TRUE, p.value = TRUE, num.permutations = 1000, 
plot_title = "Manhattan Distance Between Groups")
cchebyshev(groups, plot = TRUE, p.value = TRUE, num.permutations = 1000, 
plot_title = "Chebyshev Distance Between Groups")


}
