% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/makeStoppingCondition.R
\name{makeStoppingCondition}
\alias{makeStoppingCondition}
\title{Generate a stopping condition object.}
\usage{
makeStoppingCondition(name, message, stop.fun, code = name,
  control = list())
}
\arguments{
\item{name}{[\code{character(1)}]\cr
Name of the stopping condition.}

\item{message}{[\code{character(1)}]\cr
Message returned if the stopping conditions is active.}

\item{stop.fun}{[\code{function}]\cr
Function which expects an environment \code{envir} as its only argument and
returns a single logical value.}

\item{code}{[\code{character(1)}]\cr
Internal code, i.e., short name used to potentially trigger restarts.
Default is \code{name}.}

\item{control}{[\code{list}]\cr
Control params.}
}
\value{
[\code{cma_stopping_condition}] Stopping condition object.
}
\description{
A list of stopping conditions can be passed to the \code{\link{cmaes}}
function. Instead of hardconding the stopping criteria into the main function
they exist as stand-alone functions for maximal flexibility and extendability.
}

