% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clusternor.R
\name{KmeansPP}
\alias{KmeansPP}
\title{Perform the k-means++ clustering algorithm on a data matrix.}
\usage{
KmeansPP(data, centers, nrow = -1, ncol = -1, nstart = 1,
  nthread = -1, dist.type = c("sqeucl", "eucl", "cos", "taxi"))
}
\arguments{
\item{data}{Data file name on disk (NUMA optimized) or In memory data matrix}

\item{centers}{The number of centers (i.e., k)}

\item{nrow}{The number of samples in the dataset}

\item{ncol}{The number of features in the dataset}

\item{nstart}{The number of iterations of kmeans++ to run}

\item{nthread}{The number of parallel threads to run}

\item{dist.type}{What dissimilarity metric to use c("taxi", "eucl", "cos")}
}
\value{
A list containing the attributes of the output of kmedoids.
 cluster: A vector of integers (from 1:\strong{k}) indicating the cluster to
         which each point is allocated.
 centers: A matrix of cluster centres.
 size: The number of points in each cluster.
 energy: The sum of distances for each sample from it's closest cluster.
 best.start: The sum of distances for each sample from it's closest cluster.
}
\description{
A parallel and scalable implementation of the algorithm described in
Ostrovsky, Rafail, et al. "The effectiveness of Lloyd-type methods for
 the k-means problem." Journal of the ACM (JACM) 59.6 (2012): 28.
}
\examples{
iris.mat <- as.matrix(iris[,1:4])
k <- length(unique(iris[, dim(iris)[2]])) # Number of unique classes
nstart <- 3
km <- KmeansPP(iris.mat, k, nstart=nstart)

}
\author{
Disa Mhembere <disa@cs.jhu.edu>
}
